/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsContentRequest;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsContentResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetJobLogsContentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetJobLogsContentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetJobLogsContentRequest interceptRequest(GetJobLogsContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetJobLogsContentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("jobs").path(HttpUtils.encodePathSegment(request.getJobId())).path("logs").path("content");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("text/plain");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetJobLogsContentResponse> fromResponse() {
        Function<Response, GetJobLogsContentResponse> transformer = new Function<Response, GetJobLogsContentResponse>(){

            public GetJobLogsContentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetJobLogsContentResponse");
                Function<Response, WithHeaders<String>> responseFn = RESPONSE_CONVERSION_FACTORY.create(String.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetJobLogsContentResponse.Builder builder = GetJobLogsContentResponse.builder();
                builder.value((String)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetJobLogsContentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

