/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetJobLogsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetJobLogsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetJobLogsRequest interceptRequest(GetJobLogsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetJobLogsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("jobs").path(HttpUtils.encodePathSegment(request.getJobId())).path("logs");
        if (request.getType() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "type", request.getType(), CollectionFormatType.Multi);
        }
        if (request.getLevelGreaterThanOrEqualTo() != null) {
            target = target.queryParam("levelGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getLevelGreaterThanOrEqualTo().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getTimestampGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timestampGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimestampGreaterThanOrEqualTo()));
        }
        if (request.getTimestampLessThanOrEqualTo() != null) {
            target = target.queryParam("timestampLessThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimestampLessThanOrEqualTo()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetJobLogsResponse> fromResponse() {
        Function<Response, GetJobLogsResponse> transformer = new Function<Response, GetJobLogsResponse>(){

            public GetJobLogsResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for GetJobLogsResponse");
                Function<Response, WithHeaders<List<LogEntry>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<LogEntry>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetJobLogsResponse.Builder builder = GetJobLogsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                GetJobLogsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

