/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.model.TerraformVersionCollection;
import com.oracle.bmc.resourcemanager.requests.ListTerraformVersionsRequest;
import com.oracle.bmc.resourcemanager.responses.ListTerraformVersionsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTerraformVersionsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTerraformVersionsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTerraformVersionsRequest interceptRequest(ListTerraformVersionsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTerraformVersionsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("terraformVersions");
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListTerraformVersionsResponse> fromResponse() {
        Function<Response, ListTerraformVersionsResponse> transformer = new Function<Response, ListTerraformVersionsResponse>(){

            public ListTerraformVersionsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ListTerraformVersionsResponse");
                Function<Response, WithHeaders<TerraformVersionCollection>> responseFn = RESPONSE_CONVERSION_FACTORY.create(TerraformVersionCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListTerraformVersionsResponse.Builder builder = ListTerraformVersionsResponse.builder();
                builder.terraformVersionCollection((TerraformVersionCollection)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListTerraformVersionsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

