/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.CreateJobDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateJobRequest
extends BmcRequest {
    private CreateJobDetails createJobDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"createJobDetails", "opcRequestId", "opcRetryToken"})
    CreateJobRequest(CreateJobDetails createJobDetails, String opcRequestId, String opcRetryToken) {
        this.createJobDetails = createJobDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateJobDetails getCreateJobDetails() {
        return this.createJobDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateJobDetails createJobDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateJobRequest o) {
            this.createJobDetails(o.getCreateJobDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateJobRequest build() {
            CreateJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createJobDetails(CreateJobDetails createJobDetails) {
            this.createJobDetails = createJobDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateJobRequest buildWithoutInvocationCallback() {
            return new CreateJobRequest(this.createJobDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateJobRequest.Builder(createJobDetails=" + this.createJobDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

