/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.UpdateJobDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateJobRequest
extends BmcRequest {
    private String jobId;
    private UpdateJobDetails updateJobDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"jobId", "updateJobDetails", "opcRequestId", "ifMatch"})
    UpdateJobRequest(String jobId, UpdateJobDetails updateJobDetails, String opcRequestId, String ifMatch) {
        this.jobId = jobId;
        this.updateJobDetails = updateJobDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getJobId() {
        return this.jobId;
    }

    public UpdateJobDetails getUpdateJobDetails() {
        return this.updateJobDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String jobId;
        private UpdateJobDetails updateJobDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateJobRequest o) {
            this.jobId(o.getJobId());
            this.updateJobDetails(o.getUpdateJobDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateJobRequest build() {
            UpdateJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder updateJobDetails(UpdateJobDetails updateJobDetails) {
            this.updateJobDetails = updateJobDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateJobRequest buildWithoutInvocationCallback() {
            return new UpdateJobRequest(this.jobId, this.updateJobDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateJobRequest.Builder(jobId=" + this.jobId + ", updateJobDetails=" + this.updateJobDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

