/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.UpdateStackDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateStackRequest
extends BmcRequest {
    private String stackId;
    private UpdateStackDetails updateStackDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"stackId", "updateStackDetails", "opcRequestId", "ifMatch"})
    UpdateStackRequest(String stackId, UpdateStackDetails updateStackDetails, String opcRequestId, String ifMatch) {
        this.stackId = stackId;
        this.updateStackDetails = updateStackDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStackId() {
        return this.stackId;
    }

    public UpdateStackDetails getUpdateStackDetails() {
        return this.updateStackDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String stackId;
        private UpdateStackDetails updateStackDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateStackRequest o) {
            this.stackId(o.getStackId());
            this.updateStackDetails(o.getUpdateStackDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateStackRequest build() {
            UpdateStackRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public Builder updateStackDetails(UpdateStackDetails updateStackDetails) {
            this.updateStackDetails = updateStackDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateStackRequest buildWithoutInvocationCallback() {
            return new UpdateStackRequest(this.stackId, this.updateStackDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateStackRequest.Builder(stackId=" + this.stackId + ", updateStackDetails=" + this.updateStackDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

