/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.responses;

import com.oracle.bmc.resourcemanager.model.Stack;
import java.beans.ConstructorProperties;

public class GetStackResponse {
    private String opcRequestId;
    private String etag;
    private Stack stack;

    @ConstructorProperties(value={"opcRequestId", "etag", "stack"})
    GetStackResponse(String opcRequestId, String etag, Stack stack) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.stack = stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Stack getStack() {
        return this.stack;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Stack stack;

        public Builder copy(GetStackResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.stack(o.getStack());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder stack(Stack stack) {
            this.stack = stack;
            return this;
        }

        public GetStackResponse build() {
            return new GetStackResponse(this.opcRequestId, this.etag, this.stack);
        }

        public String toString() {
            return "GetStackResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", stack=" + this.stack + ")";
        }
    }
}

