/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.responses;

import java.beans.ConstructorProperties;
import java.io.InputStream;

public class GetStackTfConfigResponse {
    private String opcRequestId;
    private InputStream inputStream;

    @ConstructorProperties(value={"opcRequestId", "inputStream"})
    GetStackTfConfigResponse(String opcRequestId, InputStream inputStream) {
        this.opcRequestId = opcRequestId;
        this.inputStream = inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public static class Builder {
        private String opcRequestId;
        private InputStream inputStream;

        public Builder copy(GetStackTfConfigResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.inputStream(o.getInputStream());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public GetStackTfConfigResponse build() {
            return new GetStackTfConfigResponse(this.opcRequestId, this.inputStream);
        }

        public String toString() {
            return "GetStackTfConfigResponse.Builder(opcRequestId=" + this.opcRequestId + ", inputStream=" + this.inputStream + ")";
        }
    }
}

