/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.responses;

import com.oracle.bmc.resourcemanager.model.StackSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListStacksResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<StackSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListStacksResponse(String opcRequestId, String opcNextPage, List<StackSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<StackSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<StackSummary> items;

        public Builder copy(ListStacksResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<StackSummary> items) {
            this.items = items;
            return this;
        }

        public ListStacksResponse build() {
            return new ListStacksResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListStacksResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

