/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.responses;

import com.oracle.bmc.resourcemanager.model.TerraformVersionCollection;
import java.beans.ConstructorProperties;

public class ListTerraformVersionsResponse {
    private String opcRequestId;
    private TerraformVersionCollection terraformVersionCollection;

    @ConstructorProperties(value={"opcRequestId", "terraformVersionCollection"})
    ListTerraformVersionsResponse(String opcRequestId, TerraformVersionCollection terraformVersionCollection) {
        this.opcRequestId = opcRequestId;
        this.terraformVersionCollection = terraformVersionCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public TerraformVersionCollection getTerraformVersionCollection() {
        return this.terraformVersionCollection;
    }

    public static class Builder {
        private String opcRequestId;
        private TerraformVersionCollection terraformVersionCollection;

        public Builder copy(ListTerraformVersionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.terraformVersionCollection(o.getTerraformVersionCollection());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder terraformVersionCollection(TerraformVersionCollection terraformVersionCollection) {
            this.terraformVersionCollection = terraformVersionCollection;
            return this;
        }

        public ListTerraformVersionsResponse build() {
            return new ListTerraformVersionsResponse(this.opcRequestId, this.terraformVersionCollection);
        }

        public String toString() {
            return "ListTerraformVersionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", terraformVersionCollection=" + this.terraformVersionCollection + ")";
        }
    }
}

