/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.responses;

import com.oracle.bmc.resourcemanager.model.WorkRequestError;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestErrorsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<WorkRequestError> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListWorkRequestErrorsResponse(String opcNextPage, String opcRequestId, List<WorkRequestError> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<WorkRequestError> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<WorkRequestError> items;

        public Builder copy(ListWorkRequestErrorsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<WorkRequestError> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestErrorsResponse build() {
            return new ListWorkRequestErrorsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListWorkRequestErrorsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

