/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.resourcesearch.ResourceSearchAsync;
import com.oracle.bmc.resourcesearch.internal.http.GetResourceTypeConverter;
import com.oracle.bmc.resourcesearch.internal.http.ListResourceTypesConverter;
import com.oracle.bmc.resourcesearch.internal.http.SearchResourcesConverter;
import com.oracle.bmc.resourcesearch.requests.GetResourceTypeRequest;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.requests.SearchResourcesRequest;
import com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcesearch.responses.SearchResourcesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSearchAsyncClient
implements ResourceSearchAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceSearchAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCESEARCH").serviceEndpointPrefix("query").serviceEndpointTemplate("https://query.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<GetResourceTypeResponse> getResourceType(GetResourceTypeRequest request, AsyncHandler<GetResourceTypeRequest, GetResourceTypeResponse> handler) {
        LOG.trace("Called async getResourceType");
        final GetResourceTypeRequest interceptedRequest = GetResourceTypeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetResourceTypeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetResourceTypeResponse> transformer = GetResourceTypeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetResourceTypeRequest, GetResourceTypeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetResourceTypeRequest, GetResourceTypeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetResourceTypeRequest, GetResourceTypeResponse> onSuccess = new SuccessConsumer<GetResourceTypeRequest, GetResourceTypeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetResourceTypeRequest> onError = new ErrorConsumer<GetResourceTypeRequest>(this, interceptedRequest);
                    ResourceSearchAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetResourceTypeRequest, GetResourceTypeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetResourceTypeRequest, GetResourceTypeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetResourceTypeRequest> onError = handler == null ? null : new ErrorConsumer<GetResourceTypeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetResourceTypeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceSearchAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetResourceTypeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request, AsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse> handler) {
        LOG.trace("Called async listResourceTypes");
        final ListResourceTypesRequest interceptedRequest = ListResourceTypesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListResourceTypesResponse> transformer = ListResourceTypesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListResourceTypesRequest, ListResourceTypesResponse> onSuccess = new SuccessConsumer<ListResourceTypesRequest, ListResourceTypesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListResourceTypesRequest> onError = new ErrorConsumer<ListResourceTypesRequest>(this, interceptedRequest);
                    ResourceSearchAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListResourceTypesRequest, ListResourceTypesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListResourceTypesRequest, ListResourceTypesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListResourceTypesRequest> onError = handler == null ? null : new ErrorConsumer<ListResourceTypesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListResourceTypesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceSearchAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListResourceTypesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<SearchResourcesResponse> searchResources(SearchResourcesRequest request, AsyncHandler<SearchResourcesRequest, SearchResourcesResponse> handler) {
        LOG.trace("Called async searchResources");
        final SearchResourcesRequest interceptedRequest = SearchResourcesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SearchResourcesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SearchResourcesResponse> transformer = SearchResourcesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<SearchResourcesRequest, SearchResourcesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SearchResourcesRequest, SearchResourcesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<SearchResourcesRequest, SearchResourcesResponse> onSuccess = new SuccessConsumer<SearchResourcesRequest, SearchResourcesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<SearchResourcesRequest> onError = new ErrorConsumer<SearchResourcesRequest>(this, interceptedRequest);
                    ResourceSearchAsyncClient.this.client.post(ib, interceptedRequest.getSearchDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<SearchResourcesRequest, SearchResourcesResponse> onSuccess = handler == null ? null : new SuccessConsumer<SearchResourcesRequest, SearchResourcesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<SearchResourcesRequest> onError = handler == null ? null : new ErrorConsumer<SearchResourcesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getSearchDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, SearchResourcesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceSearchAsyncClient.this.client.post(ib, interceptedRequest.getSearchDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, SearchResourcesResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceSearchAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public ResourceSearchAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ResourceSearchAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

