/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.resourcesearch.ResourceSearch;
import com.oracle.bmc.resourcesearch.model.ResourceType;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class ResourceSearchPaginators {
    private final ResourceSearch client;

    public Iterable<ListResourceTypesResponse> listResourceTypesResponseIterator(final ListResourceTypesRequest request) {
        return new ResponseIterable<ListResourceTypesRequest.Builder, ListResourceTypesRequest, ListResourceTypesResponse>(new Supplier<ListResourceTypesRequest.Builder>(){

            public ListResourceTypesRequest.Builder get() {
                return ListResourceTypesRequest.builder().copy(request);
            }
        }, new Function<ListResourceTypesResponse, String>(){

            public String apply(ListResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListResourceTypesRequest.Builder>, ListResourceTypesRequest>(){

            public ListResourceTypesRequest apply(RequestBuilderAndToken<ListResourceTypesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListResourceTypesRequest, ListResourceTypesResponse>(){

            public ListResourceTypesResponse apply(ListResourceTypesRequest request) {
                return ResourceSearchPaginators.this.client.listResourceTypes(request);
            }
        });
    }

    public Iterable<ResourceType> listResourceTypesRecordIterator(final ListResourceTypesRequest request) {
        return new ResponseRecordIterable<ListResourceTypesRequest.Builder, ListResourceTypesRequest, ListResourceTypesResponse, ResourceType>(new Supplier<ListResourceTypesRequest.Builder>(){

            public ListResourceTypesRequest.Builder get() {
                return ListResourceTypesRequest.builder().copy(request);
            }
        }, new Function<ListResourceTypesResponse, String>(){

            public String apply(ListResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListResourceTypesRequest.Builder>, ListResourceTypesRequest>(){

            public ListResourceTypesRequest apply(RequestBuilderAndToken<ListResourceTypesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListResourceTypesRequest, ListResourceTypesResponse>(){

            public ListResourceTypesResponse apply(ListResourceTypesRequest request) {
                return ResourceSearchPaginators.this.client.listResourceTypes(request);
            }
        }, new Function<ListResourceTypesResponse, List<ResourceType>>(){

            public List<ResourceType> apply(ListResourceTypesResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ResourceSearchPaginators(ResourceSearch client) {
        this.client = client;
    }
}

