/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.responses;

import com.oracle.bmc.resourcesearch.model.ResourceType;
import java.beans.ConstructorProperties;

public class GetResourceTypeResponse {
    private String opcRequestId;
    private ResourceType resourceType;

    @ConstructorProperties(value={"opcRequestId", "resourceType"})
    GetResourceTypeResponse(String opcRequestId, ResourceType resourceType) {
        this.opcRequestId = opcRequestId;
        this.resourceType = resourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public static class Builder {
        private String opcRequestId;
        private ResourceType resourceType;

        public Builder copy(GetResourceTypeResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.resourceType(o.getResourceType());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public GetResourceTypeResponse build() {
            return new GetResourceTypeResponse(this.opcRequestId, this.resourceType);
        }

        public String toString() {
            return "GetResourceTypeResponse.Builder(opcRequestId=" + this.opcRequestId + ", resourceType=" + this.resourceType + ")";
        }
    }
}

