/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waiter.GenericWaiter;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.mutable.MutableObject;

public class BmcGenericRetrier {
    private final GenericWaiter waiter;
    private final RetryCondition retryCondition;

    public BmcGenericRetrier(@NonNull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked @NonNull but is null");
        }
        this.waiter = new GenericWaiter(retryConfiguration);
        this.retryCondition = retryConfiguration.getRetryCondition();
    }

    public <REQUEST, RESPONSE> RESPONSE execute(@NonNull REQUEST requestToUse, @NonNull Function<REQUEST, RESPONSE> functionCall) {
        if (requestToUse == null) {
            throw new NullPointerException("requestToUse is marked @NonNull but is null");
        }
        if (functionCall == null) {
            throw new NullPointerException("functionCall is marked @NonNull but is null");
        }
        MutableObject lastKnownException = new MutableObject();
        Optional response = this.waiter.execute(Suppliers.ofInstance(requestToUse), request -> {
            try {
                return functionCall.apply(request);
            }
            catch (BmcException e) {
                if (!this.retryCondition.shouldBeRetried(e)) {
                    throw e;
                }
                lastKnownException.setValue((Object)e);
                return null;
            }
        }, Objects::nonNull);
        if (response.isPresent()) {
            return (RESPONSE)response.get();
        }
        throw (BmcException)lastKnownException.getValue();
    }
}

