/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAdminAsync;
import com.oracle.bmc.streaming.internal.http.ChangeStreamCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.CreateArchiverConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamConverter;
import com.oracle.bmc.streaming.internal.http.GetArchiverConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamsConverter;
import com.oracle.bmc.streaming.internal.http.StartArchiverConverter;
import com.oracle.bmc.streaming.internal.http.StopArchiverConverter;
import com.oracle.bmc.streaming.internal.http.UpdateArchiverConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamConverter;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateArchiverRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetArchiverRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.StartArchiverRequest;
import com.oracle.bmc.streaming.requests.StopArchiverRequest;
import com.oracle.bmc.streaming.requests.UpdateArchiverRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateArchiverResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetArchiverResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.StartArchiverResponse;
import com.oracle.bmc.streaming.responses.StopArchiverResponse;
import com.oracle.bmc.streaming.responses.UpdateArchiverResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminAsyncClient
implements StreamAdminAsync {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeStreamCompartmentResponse> changeStreamCompartment(ChangeStreamCompartmentRequest request, AsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handler) {
        LOG.trace("Called async changeStreamCompartment");
        final ChangeStreamCompartmentRequest interceptedRequest = ChangeStreamCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeStreamCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeStreamCompartmentResponse> transformer = ChangeStreamCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> onSuccess = new SuccessConsumer<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeStreamCompartmentRequest> onError = new ErrorConsumer<ChangeStreamCompartmentRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.post(ib, interceptedRequest.getChangeStreamCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeStreamCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeStreamCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeStreamCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeStreamCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.post(ib, interceptedRequest.getChangeStreamCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeStreamCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateArchiverResponse> createArchiver(CreateArchiverRequest request, AsyncHandler<CreateArchiverRequest, CreateArchiverResponse> handler) {
        LOG.trace("Called async createArchiver");
        final CreateArchiverRequest interceptedRequest = CreateArchiverConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateArchiverConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateArchiverResponse> transformer = CreateArchiverConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateArchiverRequest, CreateArchiverResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateArchiverRequest, CreateArchiverResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateArchiverRequest, CreateArchiverResponse> onSuccess = new SuccessConsumer<CreateArchiverRequest, CreateArchiverResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateArchiverRequest> onError = new ErrorConsumer<CreateArchiverRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.post(ib, interceptedRequest.getCreateArchiverDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateArchiverRequest, CreateArchiverResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateArchiverRequest, CreateArchiverResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateArchiverRequest> onError = handler == null ? null : new ErrorConsumer<CreateArchiverRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateArchiverDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateArchiverResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.post(ib, interceptedRequest.getCreateArchiverDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateArchiverResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateStreamResponse> createStream(CreateStreamRequest request, AsyncHandler<CreateStreamRequest, CreateStreamResponse> handler) {
        LOG.trace("Called async createStream");
        final CreateStreamRequest interceptedRequest = CreateStreamConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateStreamConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateStreamResponse> transformer = CreateStreamConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateStreamRequest, CreateStreamResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateStreamRequest, CreateStreamResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateStreamRequest, CreateStreamResponse> onSuccess = new SuccessConsumer<CreateStreamRequest, CreateStreamResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateStreamRequest> onError = new ErrorConsumer<CreateStreamRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.post(ib, interceptedRequest.getCreateStreamDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateStreamRequest, CreateStreamResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateStreamRequest, CreateStreamResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateStreamRequest> onError = handler == null ? null : new ErrorConsumer<CreateStreamRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateStreamDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateStreamResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.post(ib, interceptedRequest.getCreateStreamDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateStreamResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteStreamResponse> deleteStream(DeleteStreamRequest request, AsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handler) {
        LOG.trace("Called async deleteStream");
        final DeleteStreamRequest interceptedRequest = DeleteStreamConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteStreamConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteStreamResponse> transformer = DeleteStreamConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteStreamRequest, DeleteStreamResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteStreamRequest, DeleteStreamResponse> onSuccess = new SuccessConsumer<DeleteStreamRequest, DeleteStreamResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteStreamRequest> onError = new ErrorConsumer<DeleteStreamRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteStreamRequest, DeleteStreamResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteStreamRequest, DeleteStreamResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteStreamRequest> onError = handler == null ? null : new ErrorConsumer<DeleteStreamRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteStreamResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteStreamResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetArchiverResponse> getArchiver(GetArchiverRequest request, AsyncHandler<GetArchiverRequest, GetArchiverResponse> handler) {
        LOG.trace("Called async getArchiver");
        final GetArchiverRequest interceptedRequest = GetArchiverConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetArchiverConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetArchiverResponse> transformer = GetArchiverConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetArchiverRequest, GetArchiverResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetArchiverRequest, GetArchiverResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetArchiverRequest, GetArchiverResponse> onSuccess = new SuccessConsumer<GetArchiverRequest, GetArchiverResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetArchiverRequest> onError = new ErrorConsumer<GetArchiverRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetArchiverRequest, GetArchiverResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetArchiverRequest, GetArchiverResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetArchiverRequest> onError = handler == null ? null : new ErrorConsumer<GetArchiverRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetArchiverResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetArchiverResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetStreamResponse> getStream(GetStreamRequest request, AsyncHandler<GetStreamRequest, GetStreamResponse> handler) {
        LOG.trace("Called async getStream");
        final GetStreamRequest interceptedRequest = GetStreamConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetStreamConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetStreamResponse> transformer = GetStreamConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetStreamRequest, GetStreamResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetStreamRequest, GetStreamResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetStreamRequest, GetStreamResponse> onSuccess = new SuccessConsumer<GetStreamRequest, GetStreamResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetStreamRequest> onError = new ErrorConsumer<GetStreamRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetStreamRequest, GetStreamResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetStreamRequest, GetStreamResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetStreamRequest> onError = handler == null ? null : new ErrorConsumer<GetStreamRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetStreamResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetStreamResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListStreamsResponse> listStreams(ListStreamsRequest request, AsyncHandler<ListStreamsRequest, ListStreamsResponse> handler) {
        LOG.trace("Called async listStreams");
        final ListStreamsRequest interceptedRequest = ListStreamsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListStreamsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListStreamsResponse> transformer = ListStreamsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListStreamsRequest, ListStreamsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListStreamsRequest, ListStreamsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListStreamsRequest, ListStreamsResponse> onSuccess = new SuccessConsumer<ListStreamsRequest, ListStreamsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListStreamsRequest> onError = new ErrorConsumer<ListStreamsRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListStreamsRequest, ListStreamsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListStreamsRequest, ListStreamsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListStreamsRequest> onError = handler == null ? null : new ErrorConsumer<ListStreamsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListStreamsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListStreamsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StartArchiverResponse> startArchiver(StartArchiverRequest request, AsyncHandler<StartArchiverRequest, StartArchiverResponse> handler) {
        LOG.trace("Called async startArchiver");
        final StartArchiverRequest interceptedRequest = StartArchiverConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StartArchiverConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StartArchiverResponse> transformer = StartArchiverConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StartArchiverRequest, StartArchiverResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StartArchiverRequest, StartArchiverResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StartArchiverRequest, StartArchiverResponse> onSuccess = new SuccessConsumer<StartArchiverRequest, StartArchiverResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StartArchiverRequest> onError = new ErrorConsumer<StartArchiverRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StartArchiverRequest, StartArchiverResponse> onSuccess = handler == null ? null : new SuccessConsumer<StartArchiverRequest, StartArchiverResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StartArchiverRequest> onError = handler == null ? null : new ErrorConsumer<StartArchiverRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StartArchiverResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StartArchiverResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StopArchiverResponse> stopArchiver(StopArchiverRequest request, AsyncHandler<StopArchiverRequest, StopArchiverResponse> handler) {
        LOG.trace("Called async stopArchiver");
        final StopArchiverRequest interceptedRequest = StopArchiverConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StopArchiverConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StopArchiverResponse> transformer = StopArchiverConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StopArchiverRequest, StopArchiverResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StopArchiverRequest, StopArchiverResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StopArchiverRequest, StopArchiverResponse> onSuccess = new SuccessConsumer<StopArchiverRequest, StopArchiverResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StopArchiverRequest> onError = new ErrorConsumer<StopArchiverRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StopArchiverRequest, StopArchiverResponse> onSuccess = handler == null ? null : new SuccessConsumer<StopArchiverRequest, StopArchiverResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StopArchiverRequest> onError = handler == null ? null : new ErrorConsumer<StopArchiverRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StopArchiverResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StopArchiverResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateArchiverResponse> updateArchiver(UpdateArchiverRequest request, AsyncHandler<UpdateArchiverRequest, UpdateArchiverResponse> handler) {
        LOG.trace("Called async updateArchiver");
        final UpdateArchiverRequest interceptedRequest = UpdateArchiverConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateArchiverConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateArchiverResponse> transformer = UpdateArchiverConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateArchiverRequest, UpdateArchiverResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateArchiverRequest, UpdateArchiverResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateArchiverRequest, UpdateArchiverResponse> onSuccess = new SuccessConsumer<UpdateArchiverRequest, UpdateArchiverResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateArchiverRequest> onError = new ErrorConsumer<UpdateArchiverRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.put(ib, interceptedRequest.getUpdateArchiverDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateArchiverRequest, UpdateArchiverResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateArchiverRequest, UpdateArchiverResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateArchiverRequest> onError = handler == null ? null : new ErrorConsumer<UpdateArchiverRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateArchiverDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateArchiverResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.put(ib, interceptedRequest.getUpdateArchiverDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateArchiverResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateStreamResponse> updateStream(UpdateStreamRequest request, AsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handler) {
        LOG.trace("Called async updateStream");
        final UpdateStreamRequest interceptedRequest = UpdateStreamConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateStreamConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateStreamResponse> transformer = UpdateStreamConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateStreamRequest, UpdateStreamResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateStreamRequest, UpdateStreamResponse> onSuccess = new SuccessConsumer<UpdateStreamRequest, UpdateStreamResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateStreamRequest> onError = new ErrorConsumer<UpdateStreamRequest>(this, interceptedRequest);
                    StreamAdminAsyncClient.this.client.put(ib, interceptedRequest.getUpdateStreamDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateStreamRequest, UpdateStreamResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateStreamRequest, UpdateStreamResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateStreamRequest> onError = handler == null ? null : new ErrorConsumer<UpdateStreamRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateStreamDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateStreamResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAdminAsyncClient.this.client.put(ib, interceptedRequest.getUpdateStreamDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateStreamResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public StreamAdminAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new StreamAdminAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

