/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.StreamAdminPaginators;
import com.oracle.bmc.streaming.StreamAdminWaiters;
import com.oracle.bmc.streaming.internal.http.ChangeStreamCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.CreateArchiverConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamConverter;
import com.oracle.bmc.streaming.internal.http.GetArchiverConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamsConverter;
import com.oracle.bmc.streaming.internal.http.StartArchiverConverter;
import com.oracle.bmc.streaming.internal.http.StopArchiverConverter;
import com.oracle.bmc.streaming.internal.http.UpdateArchiverConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamConverter;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateArchiverRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetArchiverRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.StartArchiverRequest;
import com.oracle.bmc.streaming.requests.StopArchiverRequest;
import com.oracle.bmc.streaming.requests.UpdateArchiverRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateArchiverResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetArchiverResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.StartArchiverResponse;
import com.oracle.bmc.streaming.responses.StopArchiverResponse;
import com.oracle.bmc.streaming.responses.UpdateArchiverResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminClient
implements StreamAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final StreamAdminWaiters waiters;
    private final StreamAdminPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StreamAdmin-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new StreamAdminWaiters(executorService, this);
        this.paginators = new StreamAdminPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeStreamCompartmentResponse changeStreamCompartment(ChangeStreamCompartmentRequest request) {
        LOG.trace("Called changeStreamCompartment");
        ChangeStreamCompartmentRequest interceptedRequest = ChangeStreamCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStreamCompartmentResponse> transformer = ChangeStreamCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeStreamCompartmentDetails(), retriedRequest);
                return (ChangeStreamCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateArchiverResponse createArchiver(CreateArchiverRequest request) {
        LOG.trace("Called createArchiver");
        CreateArchiverRequest interceptedRequest = CreateArchiverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateArchiverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateArchiverResponse> transformer = CreateArchiverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateArchiverDetails(), retriedRequest);
                return (CreateArchiverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateStreamResponse createStream(CreateStreamRequest request) {
        LOG.trace("Called createStream");
        CreateStreamRequest interceptedRequest = CreateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStreamResponse> transformer = CreateStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateStreamDetails(), retriedRequest);
                return (CreateStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest request) {
        LOG.trace("Called deleteStream");
        DeleteStreamRequest interceptedRequest = DeleteStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStreamResponse> transformer = DeleteStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetArchiverResponse getArchiver(GetArchiverRequest request) {
        LOG.trace("Called getArchiver");
        GetArchiverRequest interceptedRequest = GetArchiverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetArchiverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetArchiverResponse> transformer = GetArchiverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetArchiverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStreamResponse getStream(GetStreamRequest request) {
        LOG.trace("Called getStream");
        GetStreamRequest interceptedRequest = GetStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStreamResponse> transformer = GetStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest request) {
        LOG.trace("Called listStreams");
        ListStreamsRequest interceptedRequest = ListStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStreamsResponse> transformer = ListStreamsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListStreamsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartArchiverResponse startArchiver(StartArchiverRequest request) {
        LOG.trace("Called startArchiver");
        StartArchiverRequest interceptedRequest = StartArchiverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartArchiverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartArchiverResponse> transformer = StartArchiverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StartArchiverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopArchiverResponse stopArchiver(StopArchiverRequest request) {
        LOG.trace("Called stopArchiver");
        StopArchiverRequest interceptedRequest = StopArchiverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopArchiverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopArchiverResponse> transformer = StopArchiverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StopArchiverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateArchiverResponse updateArchiver(UpdateArchiverRequest request) {
        LOG.trace("Called updateArchiver");
        UpdateArchiverRequest interceptedRequest = UpdateArchiverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateArchiverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateArchiverResponse> transformer = UpdateArchiverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateArchiverDetails(), retriedRequest);
                return (UpdateArchiverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateStreamResponse updateStream(UpdateStreamRequest request) {
        LOG.trace("Called updateStream");
        UpdateStreamRequest interceptedRequest = UpdateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStreamResponse> transformer = UpdateStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateStreamDetails(), retriedRequest);
                return (UpdateStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StreamAdminWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public StreamAdminPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public StreamAdminClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new StreamAdminClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

