/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.model.StreamSummary;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class StreamAdminPaginators {
    private final StreamAdmin client;

    public Iterable<ListStreamsResponse> listStreamsResponseIterator(final ListStreamsRequest request) {
        return new ResponseIterable<ListStreamsRequest.Builder, ListStreamsRequest, ListStreamsResponse>(new Supplier<ListStreamsRequest.Builder>(){

            public ListStreamsRequest.Builder get() {
                return ListStreamsRequest.builder().copy(request);
            }
        }, new Function<ListStreamsResponse, String>(){

            public String apply(ListStreamsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListStreamsRequest.Builder>, ListStreamsRequest>(){

            public ListStreamsRequest apply(RequestBuilderAndToken<ListStreamsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListStreamsRequest, ListStreamsResponse>(){

            public ListStreamsResponse apply(ListStreamsRequest request) {
                return StreamAdminPaginators.this.client.listStreams(request);
            }
        });
    }

    public Iterable<StreamSummary> listStreamsRecordIterator(final ListStreamsRequest request) {
        return new ResponseRecordIterable<ListStreamsRequest.Builder, ListStreamsRequest, ListStreamsResponse, StreamSummary>(new Supplier<ListStreamsRequest.Builder>(){

            public ListStreamsRequest.Builder get() {
                return ListStreamsRequest.builder().copy(request);
            }
        }, new Function<ListStreamsResponse, String>(){

            public String apply(ListStreamsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListStreamsRequest.Builder>, ListStreamsRequest>(){

            public ListStreamsRequest apply(RequestBuilderAndToken<ListStreamsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListStreamsRequest, ListStreamsResponse>(){

            public ListStreamsResponse apply(ListStreamsRequest request) {
                return StreamAdminPaginators.this.client.listStreams(request);
            }
        }, new Function<ListStreamsResponse, List<StreamSummary>>(){

            public List<StreamSummary> apply(ListStreamsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public StreamAdminPaginators(StreamAdmin client) {
        this.client = client;
    }
}

