/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.model.ArchiverLifecycleState;
import com.oracle.bmc.streaming.model.Stream;
import com.oracle.bmc.streaming.requests.GetArchiverRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.responses.GetArchiverResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class StreamAdminWaiters {
    private final ExecutorService executorService;
    private final StreamAdmin client;

    public Waiter<GetArchiverRequest, GetArchiverResponse> forArchiver(GetArchiverRequest request, ArchiverLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forArchiver(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetArchiverRequest, GetArchiverResponse> forArchiver(GetArchiverRequest request, ArchiverLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forArchiver(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetArchiverRequest, GetArchiverResponse> forArchiver(GetArchiverRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ArchiverLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forArchiver(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetArchiverRequest, GetArchiverResponse> forArchiver(BmcGenericWaiter waiter, GetArchiverRequest request, ArchiverLifecycleState ... targetStates) {
        final HashSet<ArchiverLifecycleState> targetStatesSet = new HashSet<ArchiverLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetArchiverRequest, GetArchiverResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetArchiverRequest, GetArchiverResponse>(){

            public GetArchiverResponse apply(GetArchiverRequest request) {
                return StreamAdminWaiters.this.client.getArchiver(request);
            }
        }, new Predicate<GetArchiverResponse>(){

            public boolean apply(GetArchiverResponse response) {
                return targetStatesSet.contains((Object)response.getArchiver().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetStreamRequest, GetStreamResponse> forStream(GetStreamRequest request, Stream.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStream(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStreamRequest, GetStreamResponse> forStream(GetStreamRequest request, Stream.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStream(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetStreamRequest, GetStreamResponse> forStream(GetStreamRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Stream.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStream(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetStreamRequest, GetStreamResponse> forStream(BmcGenericWaiter waiter, GetStreamRequest request, Stream.LifecycleState ... targetStates) {
        final HashSet<Stream.LifecycleState> targetStatesSet = new HashSet<Stream.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetStreamRequest, GetStreamResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetStreamRequest, GetStreamResponse>(){

            public GetStreamResponse apply(GetStreamRequest request) {
                return StreamAdminWaiters.this.client.getStream(request);
            }
        }, new Predicate<GetStreamResponse>(){

            public boolean apply(GetStreamResponse response) {
                return targetStatesSet.contains((Object)response.getStream().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Stream.LifecycleState.Deleted)), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public StreamAdminWaiters(ExecutorService executorService, StreamAdmin client) {
        this.executorService = executorService;
        this.client = client;
    }
}

