/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAsync;
import com.oracle.bmc.streaming.internal.http.ConsumerCommitConverter;
import com.oracle.bmc.streaming.internal.http.ConsumerHeartbeatConverter;
import com.oracle.bmc.streaming.internal.http.CreateCursorConverter;
import com.oracle.bmc.streaming.internal.http.CreateGroupCursorConverter;
import com.oracle.bmc.streaming.internal.http.GetGroupConverter;
import com.oracle.bmc.streaming.internal.http.GetMessagesConverter;
import com.oracle.bmc.streaming.internal.http.PutMessagesConverter;
import com.oracle.bmc.streaming.internal.http.UpdateGroupConverter;
import com.oracle.bmc.streaming.requests.ConsumerCommitRequest;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.requests.CreateCursorRequest;
import com.oracle.bmc.streaming.requests.CreateGroupCursorRequest;
import com.oracle.bmc.streaming.requests.GetGroupRequest;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.requests.PutMessagesRequest;
import com.oracle.bmc.streaming.requests.UpdateGroupRequest;
import com.oracle.bmc.streaming.responses.ConsumerCommitResponse;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.streaming.responses.CreateCursorResponse;
import com.oracle.bmc.streaming.responses.CreateGroupCursorResponse;
import com.oracle.bmc.streaming.responses.GetGroupResponse;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.streaming.responses.PutMessagesResponse;
import com.oracle.bmc.streaming.responses.UpdateGroupResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAsyncClient
implements StreamAsync {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAM").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public StreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ConsumerCommitResponse> consumerCommit(ConsumerCommitRequest request, AsyncHandler<ConsumerCommitRequest, ConsumerCommitResponse> handler) {
        LOG.trace("Called async consumerCommit");
        final ConsumerCommitRequest interceptedRequest = ConsumerCommitConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ConsumerCommitConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ConsumerCommitResponse> transformer = ConsumerCommitConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ConsumerCommitRequest, ConsumerCommitResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ConsumerCommitRequest, ConsumerCommitResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ConsumerCommitRequest, ConsumerCommitResponse> onSuccess = new SuccessConsumer<ConsumerCommitRequest, ConsumerCommitResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ConsumerCommitRequest> onError = new ErrorConsumer<ConsumerCommitRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ConsumerCommitRequest, ConsumerCommitResponse> onSuccess = handler == null ? null : new SuccessConsumer<ConsumerCommitRequest, ConsumerCommitResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ConsumerCommitRequest> onError = handler == null ? null : new ErrorConsumer<ConsumerCommitRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ConsumerCommitResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ConsumerCommitResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ConsumerHeartbeatResponse> consumerHeartbeat(ConsumerHeartbeatRequest request, AsyncHandler<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse> handler) {
        LOG.trace("Called async consumerHeartbeat");
        final ConsumerHeartbeatRequest interceptedRequest = ConsumerHeartbeatConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ConsumerHeartbeatConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ConsumerHeartbeatResponse> transformer = ConsumerHeartbeatConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse> onSuccess = new SuccessConsumer<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ConsumerHeartbeatRequest> onError = new ErrorConsumer<ConsumerHeartbeatRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse> onSuccess = handler == null ? null : new SuccessConsumer<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ConsumerHeartbeatRequest> onError = handler == null ? null : new ErrorConsumer<ConsumerHeartbeatRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ConsumerHeartbeatResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ConsumerHeartbeatResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCursorResponse> createCursor(CreateCursorRequest request, AsyncHandler<CreateCursorRequest, CreateCursorResponse> handler) {
        LOG.trace("Called async createCursor");
        final CreateCursorRequest interceptedRequest = CreateCursorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCursorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCursorResponse> transformer = CreateCursorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCursorRequest, CreateCursorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCursorRequest, CreateCursorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCursorRequest, CreateCursorResponse> onSuccess = new SuccessConsumer<CreateCursorRequest, CreateCursorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCursorRequest> onError = new ErrorConsumer<CreateCursorRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.post(ib, interceptedRequest.getCreateCursorDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCursorRequest, CreateCursorResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCursorRequest, CreateCursorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCursorRequest> onError = handler == null ? null : new ErrorConsumer<CreateCursorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCursorDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCursorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.post(ib, interceptedRequest.getCreateCursorDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCursorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateGroupCursorResponse> createGroupCursor(CreateGroupCursorRequest request, AsyncHandler<CreateGroupCursorRequest, CreateGroupCursorResponse> handler) {
        LOG.trace("Called async createGroupCursor");
        final CreateGroupCursorRequest interceptedRequest = CreateGroupCursorConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateGroupCursorConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateGroupCursorResponse> transformer = CreateGroupCursorConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateGroupCursorRequest, CreateGroupCursorResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateGroupCursorRequest, CreateGroupCursorResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateGroupCursorRequest, CreateGroupCursorResponse> onSuccess = new SuccessConsumer<CreateGroupCursorRequest, CreateGroupCursorResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateGroupCursorRequest> onError = new ErrorConsumer<CreateGroupCursorRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.post(ib, interceptedRequest.getCreateGroupCursorDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateGroupCursorRequest, CreateGroupCursorResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateGroupCursorRequest, CreateGroupCursorResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateGroupCursorRequest> onError = handler == null ? null : new ErrorConsumer<CreateGroupCursorRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateGroupCursorDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateGroupCursorResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.post(ib, interceptedRequest.getCreateGroupCursorDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateGroupCursorResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetGroupResponse> getGroup(GetGroupRequest request, AsyncHandler<GetGroupRequest, GetGroupResponse> handler) {
        LOG.trace("Called async getGroup");
        final GetGroupRequest interceptedRequest = GetGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetGroupResponse> transformer = GetGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetGroupRequest, GetGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetGroupRequest, GetGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetGroupRequest, GetGroupResponse> onSuccess = new SuccessConsumer<GetGroupRequest, GetGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetGroupRequest> onError = new ErrorConsumer<GetGroupRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetGroupRequest, GetGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetGroupRequest, GetGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetGroupRequest> onError = handler == null ? null : new ErrorConsumer<GetGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetMessagesResponse> getMessages(GetMessagesRequest request, AsyncHandler<GetMessagesRequest, GetMessagesResponse> handler) {
        LOG.trace("Called async getMessages");
        final GetMessagesRequest interceptedRequest = GetMessagesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetMessagesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetMessagesResponse> transformer = GetMessagesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetMessagesRequest, GetMessagesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetMessagesRequest, GetMessagesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetMessagesRequest, GetMessagesResponse> onSuccess = new SuccessConsumer<GetMessagesRequest, GetMessagesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetMessagesRequest> onError = new ErrorConsumer<GetMessagesRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetMessagesRequest, GetMessagesResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetMessagesRequest, GetMessagesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetMessagesRequest> onError = handler == null ? null : new ErrorConsumer<GetMessagesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetMessagesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetMessagesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PutMessagesResponse> putMessages(PutMessagesRequest request, AsyncHandler<PutMessagesRequest, PutMessagesResponse> handler) {
        LOG.trace("Called async putMessages");
        final PutMessagesRequest interceptedRequest = PutMessagesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PutMessagesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PutMessagesResponse> transformer = PutMessagesConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RefreshAuthTokenWrappingAsyncHandler<PutMessagesRequest, PutMessagesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PutMessagesRequest, PutMessagesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PutMessagesRequest, PutMessagesResponse> onSuccess = new SuccessConsumer<PutMessagesRequest, PutMessagesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PutMessagesRequest> onError = new ErrorConsumer<PutMessagesRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.post(ib, interceptedRequest.getPutMessagesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PutMessagesRequest, PutMessagesResponse> onSuccess = handler == null ? null : new SuccessConsumer<PutMessagesRequest, PutMessagesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PutMessagesRequest> onError = handler == null ? null : new ErrorConsumer<PutMessagesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getPutMessagesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PutMessagesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.post(ib, interceptedRequest.getPutMessagesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PutMessagesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateGroupResponse> updateGroup(UpdateGroupRequest request, AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handler) {
        LOG.trace("Called async updateGroup");
        final UpdateGroupRequest interceptedRequest = UpdateGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateGroupResponse> transformer = UpdateGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateGroupRequest, UpdateGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse> onSuccess = new SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateGroupRequest> onError = new ErrorConsumer<UpdateGroupRequest>(this, interceptedRequest);
                    StreamAsyncClient.this.client.put(ib, interceptedRequest.getUpdateGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateGroupRequest, UpdateGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateGroupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return StreamAsyncClient.this.client.put(ib, interceptedRequest.getUpdateGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateGroupResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public StreamAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new StreamAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

