/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetMessagesRequest
extends BmcRequest {
    private String streamId;
    private String cursor;
    private Integer limit;
    private String opcRequestId;

    @ConstructorProperties(value={"streamId", "cursor", "limit", "opcRequestId"})
    GetMessagesRequest(String streamId, String cursor, Integer limit, String opcRequestId) {
        this.streamId = streamId;
        this.cursor = cursor;
        this.limit = limit;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String streamId;
        private String cursor;
        private Integer limit;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMessagesRequest o) {
            this.streamId(o.getStreamId());
            this.cursor(o.getCursor());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMessagesRequest build() {
            GetMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetMessagesRequest buildWithoutInvocationCallback() {
            return new GetMessagesRequest(this.streamId, this.cursor, this.limit, this.opcRequestId);
        }

        public String toString() {
            return "GetMessagesRequest.Builder(streamId=" + this.streamId + ", cursor=" + this.cursor + ", limit=" + this.limit + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

