/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateStreamDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateStreamRequest
extends BmcRequest {
    private String streamId;
    private UpdateStreamDetails updateStreamDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"streamId", "updateStreamDetails", "opcRequestId", "ifMatch"})
    UpdateStreamRequest(String streamId, UpdateStreamDetails updateStreamDetails, String opcRequestId, String ifMatch) {
        this.streamId = streamId;
        this.updateStreamDetails = updateStreamDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public UpdateStreamDetails getUpdateStreamDetails() {
        return this.updateStreamDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String streamId;
        private UpdateStreamDetails updateStreamDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateStreamRequest o) {
            this.streamId(o.getStreamId());
            this.updateStreamDetails(o.getUpdateStreamDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateStreamRequest build() {
            UpdateStreamRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder updateStreamDetails(UpdateStreamDetails updateStreamDetails) {
            this.updateStreamDetails = updateStreamDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateStreamRequest buildWithoutInvocationCallback() {
            return new UpdateStreamRequest(this.streamId, this.updateStreamDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateStreamRequest.Builder(streamId=" + this.streamId + ", updateStreamDetails=" + this.updateStreamDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

