/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.Cursor;
import java.beans.ConstructorProperties;

public class CreateGroupCursorResponse {
    private String opcRequestId;
    private Cursor cursor;

    @ConstructorProperties(value={"opcRequestId", "cursor"})
    CreateGroupCursorResponse(String opcRequestId, Cursor cursor) {
        this.opcRequestId = opcRequestId;
        this.cursor = cursor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public static class Builder {
        private String opcRequestId;
        private Cursor cursor;

        public Builder copy(CreateGroupCursorResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.cursor(o.getCursor());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder cursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public CreateGroupCursorResponse build() {
            return new CreateGroupCursorResponse(this.opcRequestId, this.cursor);
        }

        public String toString() {
            return "CreateGroupCursorResponse.Builder(opcRequestId=" + this.opcRequestId + ", cursor=" + this.cursor + ")";
        }
    }
}

