/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.Group;
import java.beans.ConstructorProperties;

public class GetGroupResponse {
    private String opcRequestId;
    private Group group;

    @ConstructorProperties(value={"opcRequestId", "group"})
    GetGroupResponse(String opcRequestId, Group group) {
        this.opcRequestId = opcRequestId;
        this.group = group;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Builder {
        private String opcRequestId;
        private Group group;

        public Builder copy(GetGroupResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.group(o.getGroup());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder group(Group group) {
            this.group = group;
            return this;
        }

        public GetGroupResponse build() {
            return new GetGroupResponse(this.opcRequestId, this.group);
        }

        public String toString() {
            return "GetGroupResponse.Builder(opcRequestId=" + this.opcRequestId + ", group=" + this.group + ")";
        }
    }
}

