/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.Message;
import java.beans.ConstructorProperties;
import java.util.List;

public class GetMessagesResponse {
    private String opcNextCursor;
    private String opcRequestId;
    private List<Message> items;

    @ConstructorProperties(value={"opcNextCursor", "opcRequestId", "items"})
    GetMessagesResponse(String opcNextCursor, String opcRequestId, List<Message> items) {
        this.opcNextCursor = opcNextCursor;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextCursor() {
        return this.opcNextCursor;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Message> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextCursor;
        private String opcRequestId;
        private List<Message> items;

        public Builder copy(GetMessagesResponse o) {
            this.opcNextCursor(o.getOpcNextCursor());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextCursor(String opcNextCursor) {
            this.opcNextCursor = opcNextCursor;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Message> items) {
            this.items = items;
            return this;
        }

        public GetMessagesResponse build() {
            return new GetMessagesResponse(this.opcNextCursor, this.opcRequestId, this.items);
        }

        public String toString() {
            return "GetMessagesResponse.Builder(opcNextCursor=" + this.opcNextCursor + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

