/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.Stream;
import java.beans.ConstructorProperties;

public class GetStreamResponse {
    private String opcRequestId;
    private String etag;
    private Stream stream;

    @ConstructorProperties(value={"opcRequestId", "etag", "stream"})
    GetStreamResponse(String opcRequestId, String etag, Stream stream) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.stream = stream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Stream getStream() {
        return this.stream;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Stream stream;

        public Builder copy(GetStreamResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.stream(o.getStream());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder stream(Stream stream) {
            this.stream = stream;
            return this;
        }

        public GetStreamResponse build() {
            return new GetStreamResponse(this.opcRequestId, this.etag, this.stream);
        }

        public String toString() {
            return "GetStreamResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", stream=" + this.stream + ")";
        }
    }
}

