/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.PutMessagesResult;
import java.beans.ConstructorProperties;

public class PutMessagesResponse {
    private String opcRequestId;
    private PutMessagesResult putMessagesResult;

    @ConstructorProperties(value={"opcRequestId", "putMessagesResult"})
    PutMessagesResponse(String opcRequestId, PutMessagesResult putMessagesResult) {
        this.opcRequestId = opcRequestId;
        this.putMessagesResult = putMessagesResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PutMessagesResult getPutMessagesResult() {
        return this.putMessagesResult;
    }

    public static class Builder {
        private String opcRequestId;
        private PutMessagesResult putMessagesResult;

        public Builder copy(PutMessagesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.putMessagesResult(o.getPutMessagesResult());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder putMessagesResult(PutMessagesResult putMessagesResult) {
            this.putMessagesResult = putMessagesResult;
            return this;
        }

        public PutMessagesResponse build() {
            return new PutMessagesResponse(this.opcRequestId, this.putMessagesResult);
        }

        public String toString() {
            return "PutMessagesResponse.Builder(opcRequestId=" + this.opcRequestId + ", putMessagesResult=" + this.putMessagesResult + ")";
        }
    }
}

