/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.Archiver;
import java.beans.ConstructorProperties;

public class StartArchiverResponse {
    private String etag;
    private String opcRequestId;
    private Archiver archiver;

    @ConstructorProperties(value={"etag", "opcRequestId", "archiver"})
    StartArchiverResponse(String etag, String opcRequestId, Archiver archiver) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.archiver = archiver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Archiver getArchiver() {
        return this.archiver;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Archiver archiver;

        public Builder copy(StartArchiverResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.archiver(o.getArchiver());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder archiver(Archiver archiver) {
            this.archiver = archiver;
            return this;
        }

        public StartArchiverResponse build() {
            return new StartArchiverResponse(this.etag, this.opcRequestId, this.archiver);
        }

        public String toString() {
            return "StartArchiverResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", archiver=" + this.archiver + ")";
        }
    }
}

