/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import com.oracle.bmc.waas.WaasAsync;
import com.oracle.bmc.waas.internal.http.AcceptRecommendationsConverter;
import com.oracle.bmc.waas.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.waas.internal.http.ChangeAddressListCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeCertificateCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeCustomProtectionRuleCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeWaasPolicyCompartmentConverter;
import com.oracle.bmc.waas.internal.http.CreateAddressListConverter;
import com.oracle.bmc.waas.internal.http.CreateCertificateConverter;
import com.oracle.bmc.waas.internal.http.CreateCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.CreateWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.DeleteAddressListConverter;
import com.oracle.bmc.waas.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.waas.internal.http.DeleteCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.DeleteWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.GetAddressListConverter;
import com.oracle.bmc.waas.internal.http.GetCertificateConverter;
import com.oracle.bmc.waas.internal.http.GetCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.GetDeviceFingerprintChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetHumanInteractionChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetJsChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetPolicyConfigConverter;
import com.oracle.bmc.waas.internal.http.GetProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.GetProtectionSettingsConverter;
import com.oracle.bmc.waas.internal.http.GetWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.GetWafAddressRateLimitingConverter;
import com.oracle.bmc.waas.internal.http.GetWafConfigConverter;
import com.oracle.bmc.waas.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.waas.internal.http.ListAccessRulesConverter;
import com.oracle.bmc.waas.internal.http.ListAddressListsConverter;
import com.oracle.bmc.waas.internal.http.ListCachingRulesConverter;
import com.oracle.bmc.waas.internal.http.ListCaptchasConverter;
import com.oracle.bmc.waas.internal.http.ListCertificatesConverter;
import com.oracle.bmc.waas.internal.http.ListCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListEdgeSubnetsConverter;
import com.oracle.bmc.waas.internal.http.ListGoodBotsConverter;
import com.oracle.bmc.waas.internal.http.ListProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.waas.internal.http.ListThreatFeedsConverter;
import com.oracle.bmc.waas.internal.http.ListWaasPoliciesConverter;
import com.oracle.bmc.waas.internal.http.ListWaasPolicyCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListWafBlockedRequestsConverter;
import com.oracle.bmc.waas.internal.http.ListWafLogsConverter;
import com.oracle.bmc.waas.internal.http.ListWafRequestsConverter;
import com.oracle.bmc.waas.internal.http.ListWafTrafficConverter;
import com.oracle.bmc.waas.internal.http.ListWhitelistsConverter;
import com.oracle.bmc.waas.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.waas.internal.http.PurgeCacheConverter;
import com.oracle.bmc.waas.internal.http.UpdateAccessRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateAddressListConverter;
import com.oracle.bmc.waas.internal.http.UpdateCachingRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateCaptchasConverter;
import com.oracle.bmc.waas.internal.http.UpdateCertificateConverter;
import com.oracle.bmc.waas.internal.http.UpdateCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.UpdateDeviceFingerprintChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdateGoodBotsConverter;
import com.oracle.bmc.waas.internal.http.UpdateHumanInteractionChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdateJsChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdatePolicyConfigConverter;
import com.oracle.bmc.waas.internal.http.UpdateProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateProtectionSettingsConverter;
import com.oracle.bmc.waas.internal.http.UpdateThreatFeedsConverter;
import com.oracle.bmc.waas.internal.http.UpdateWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.UpdateWaasPolicyCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateWafAddressRateLimitingConverter;
import com.oracle.bmc.waas.internal.http.UpdateWafConfigConverter;
import com.oracle.bmc.waas.internal.http.UpdateWhitelistsConverter;
import com.oracle.bmc.waas.requests.AcceptRecommendationsRequest;
import com.oracle.bmc.waas.requests.CancelWorkRequestRequest;
import com.oracle.bmc.waas.requests.ChangeAddressListCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCustomProtectionRuleCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeWaasPolicyCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateAddressListRequest;
import com.oracle.bmc.waas.requests.CreateCertificateRequest;
import com.oracle.bmc.waas.requests.CreateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.CreateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.DeleteAddressListRequest;
import com.oracle.bmc.waas.requests.DeleteCertificateRequest;
import com.oracle.bmc.waas.requests.DeleteCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.DeleteWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetAddressListRequest;
import com.oracle.bmc.waas.requests.GetCertificateRequest;
import com.oracle.bmc.waas.requests.GetCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.GetHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.GetJsChallengeRequest;
import com.oracle.bmc.waas.requests.GetPolicyConfigRequest;
import com.oracle.bmc.waas.requests.GetProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.GetWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.GetWafConfigRequest;
import com.oracle.bmc.waas.requests.GetWorkRequestRequest;
import com.oracle.bmc.waas.requests.ListAccessRulesRequest;
import com.oracle.bmc.waas.requests.ListAddressListsRequest;
import com.oracle.bmc.waas.requests.ListCachingRulesRequest;
import com.oracle.bmc.waas.requests.ListCaptchasRequest;
import com.oracle.bmc.waas.requests.ListCertificatesRequest;
import com.oracle.bmc.waas.requests.ListCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListEdgeSubnetsRequest;
import com.oracle.bmc.waas.requests.ListGoodBotsRequest;
import com.oracle.bmc.waas.requests.ListProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListRecommendationsRequest;
import com.oracle.bmc.waas.requests.ListThreatFeedsRequest;
import com.oracle.bmc.waas.requests.ListWaasPoliciesRequest;
import com.oracle.bmc.waas.requests.ListWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListWafBlockedRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.requests.ListWafRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafTrafficRequest;
import com.oracle.bmc.waas.requests.ListWhitelistsRequest;
import com.oracle.bmc.waas.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waas.requests.PurgeCacheRequest;
import com.oracle.bmc.waas.requests.UpdateAccessRulesRequest;
import com.oracle.bmc.waas.requests.UpdateAddressListRequest;
import com.oracle.bmc.waas.requests.UpdateCachingRulesRequest;
import com.oracle.bmc.waas.requests.UpdateCaptchasRequest;
import com.oracle.bmc.waas.requests.UpdateCertificateRequest;
import com.oracle.bmc.waas.requests.UpdateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.UpdateDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateGoodBotsRequest;
import com.oracle.bmc.waas.requests.UpdateHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateJsChallengeRequest;
import com.oracle.bmc.waas.requests.UpdatePolicyConfigRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.UpdateThreatFeedsRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.UpdateWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.UpdateWafConfigRequest;
import com.oracle.bmc.waas.requests.UpdateWhitelistsRequest;
import com.oracle.bmc.waas.responses.AcceptRecommendationsResponse;
import com.oracle.bmc.waas.responses.CancelWorkRequestResponse;
import com.oracle.bmc.waas.responses.ChangeAddressListCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCustomProtectionRuleCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeWaasPolicyCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateAddressListResponse;
import com.oracle.bmc.waas.responses.CreateCertificateResponse;
import com.oracle.bmc.waas.responses.CreateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.CreateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.DeleteAddressListResponse;
import com.oracle.bmc.waas.responses.DeleteCertificateResponse;
import com.oracle.bmc.waas.responses.DeleteCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.DeleteWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetAddressListResponse;
import com.oracle.bmc.waas.responses.GetCertificateResponse;
import com.oracle.bmc.waas.responses.GetCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.GetHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.GetJsChallengeResponse;
import com.oracle.bmc.waas.responses.GetPolicyConfigResponse;
import com.oracle.bmc.waas.responses.GetProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.GetWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.GetWafConfigResponse;
import com.oracle.bmc.waas.responses.GetWorkRequestResponse;
import com.oracle.bmc.waas.responses.ListAccessRulesResponse;
import com.oracle.bmc.waas.responses.ListAddressListsResponse;
import com.oracle.bmc.waas.responses.ListCachingRulesResponse;
import com.oracle.bmc.waas.responses.ListCaptchasResponse;
import com.oracle.bmc.waas.responses.ListCertificatesResponse;
import com.oracle.bmc.waas.responses.ListCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListEdgeSubnetsResponse;
import com.oracle.bmc.waas.responses.ListGoodBotsResponse;
import com.oracle.bmc.waas.responses.ListProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListRecommendationsResponse;
import com.oracle.bmc.waas.responses.ListThreatFeedsResponse;
import com.oracle.bmc.waas.responses.ListWaasPoliciesResponse;
import com.oracle.bmc.waas.responses.ListWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListWafBlockedRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import com.oracle.bmc.waas.responses.ListWafRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafTrafficResponse;
import com.oracle.bmc.waas.responses.ListWhitelistsResponse;
import com.oracle.bmc.waas.responses.ListWorkRequestsResponse;
import com.oracle.bmc.waas.responses.PurgeCacheResponse;
import com.oracle.bmc.waas.responses.UpdateAccessRulesResponse;
import com.oracle.bmc.waas.responses.UpdateAddressListResponse;
import com.oracle.bmc.waas.responses.UpdateCachingRulesResponse;
import com.oracle.bmc.waas.responses.UpdateCaptchasResponse;
import com.oracle.bmc.waas.responses.UpdateCertificateResponse;
import com.oracle.bmc.waas.responses.UpdateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.UpdateDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateGoodBotsResponse;
import com.oracle.bmc.waas.responses.UpdateHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateJsChallengeResponse;
import com.oracle.bmc.waas.responses.UpdatePolicyConfigResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.UpdateThreatFeedsResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.UpdateWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.UpdateWafConfigResponse;
import com.oracle.bmc.waas.responses.UpdateWhitelistsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaasAsyncClient
implements WaasAsync {
    private static final Logger LOG = LoggerFactory.getLogger(WaasAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAAS").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public WaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public WaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public WaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AcceptRecommendationsResponse> acceptRecommendations(AcceptRecommendationsRequest request, AsyncHandler<AcceptRecommendationsRequest, AcceptRecommendationsResponse> handler) {
        LOG.trace("Called async acceptRecommendations");
        final AcceptRecommendationsRequest interceptedRequest = AcceptRecommendationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AcceptRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AcceptRecommendationsResponse> transformer = AcceptRecommendationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AcceptRecommendationsRequest, AcceptRecommendationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AcceptRecommendationsRequest, AcceptRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AcceptRecommendationsRequest, AcceptRecommendationsResponse> onSuccess = new SuccessConsumer<AcceptRecommendationsRequest, AcceptRecommendationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AcceptRecommendationsRequest> onError = new ErrorConsumer<AcceptRecommendationsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getProtectionRuleKeys(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AcceptRecommendationsRequest, AcceptRecommendationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<AcceptRecommendationsRequest, AcceptRecommendationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AcceptRecommendationsRequest> onError = handler == null ? null : new ErrorConsumer<AcceptRecommendationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getProtectionRuleKeys(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AcceptRecommendationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getProtectionRuleKeys(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AcceptRecommendationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        final CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse> onSuccess = new SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CancelWorkRequestRequest> onError = new ErrorConsumer<CancelWorkRequestRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CancelWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<CancelWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CancelWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CancelWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeAddressListCompartmentResponse> changeAddressListCompartment(ChangeAddressListCompartmentRequest request, AsyncHandler<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse> handler) {
        LOG.trace("Called async changeAddressListCompartment");
        final ChangeAddressListCompartmentRequest interceptedRequest = ChangeAddressListCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeAddressListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeAddressListCompartmentResponse> transformer = ChangeAddressListCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse> onSuccess = new SuccessConsumer<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeAddressListCompartmentRequest> onError = new ErrorConsumer<ChangeAddressListCompartmentRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeAddressListCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeAddressListCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeAddressListCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeAddressListCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeAddressListCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeAddressListCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeAddressListCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request, AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handler) {
        LOG.trace("Called async changeCertificateCompartment");
        final ChangeCertificateCompartmentRequest interceptedRequest = ChangeCertificateCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeCertificateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeCertificateCompartmentResponse> transformer = ChangeCertificateCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> onSuccess = new SuccessConsumer<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeCertificateCompartmentRequest> onError = new ErrorConsumer<ChangeCertificateCompartmentRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeCertificateCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeCertificateCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeCertificateCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCertificateCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeCertificateCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeCertificateCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeCertificateCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeCustomProtectionRuleCompartmentResponse> changeCustomProtectionRuleCompartment(ChangeCustomProtectionRuleCompartmentRequest request, AsyncHandler<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse> handler) {
        LOG.trace("Called async changeCustomProtectionRuleCompartment");
        final ChangeCustomProtectionRuleCompartmentRequest interceptedRequest = ChangeCustomProtectionRuleCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeCustomProtectionRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeCustomProtectionRuleCompartmentResponse> transformer = ChangeCustomProtectionRuleCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse> onSuccess = new SuccessConsumer<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeCustomProtectionRuleCompartmentRequest> onError = new ErrorConsumer<ChangeCustomProtectionRuleCompartmentRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeCustomProtectionRuleCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeCustomProtectionRuleCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeCustomProtectionRuleCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCustomProtectionRuleCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeCustomProtectionRuleCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeCustomProtectionRuleCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeCustomProtectionRuleCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeWaasPolicyCompartmentResponse> changeWaasPolicyCompartment(ChangeWaasPolicyCompartmentRequest request, AsyncHandler<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse> handler) {
        LOG.trace("Called async changeWaasPolicyCompartment");
        final ChangeWaasPolicyCompartmentRequest interceptedRequest = ChangeWaasPolicyCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeWaasPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeWaasPolicyCompartmentResponse> transformer = ChangeWaasPolicyCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse> onSuccess = new SuccessConsumer<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeWaasPolicyCompartmentRequest> onError = new ErrorConsumer<ChangeWaasPolicyCompartmentRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeWaasPolicyCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeWaasPolicyCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeWaasPolicyCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeWaasPolicyCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeWaasPolicyCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getChangeWaasPolicyCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeWaasPolicyCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAddressListResponse> createAddressList(CreateAddressListRequest request, AsyncHandler<CreateAddressListRequest, CreateAddressListResponse> handler) {
        LOG.trace("Called async createAddressList");
        final CreateAddressListRequest interceptedRequest = CreateAddressListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAddressListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAddressListResponse> transformer = CreateAddressListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAddressListRequest, CreateAddressListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAddressListRequest, CreateAddressListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAddressListRequest, CreateAddressListResponse> onSuccess = new SuccessConsumer<CreateAddressListRequest, CreateAddressListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAddressListRequest> onError = new ErrorConsumer<CreateAddressListRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateAddressListDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAddressListRequest, CreateAddressListResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAddressListRequest, CreateAddressListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAddressListRequest> onError = handler == null ? null : new ErrorConsumer<CreateAddressListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAddressListDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAddressListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateAddressListDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAddressListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        LOG.trace("Called async createCertificate");
        final CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCertificateRequest, CreateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse> onSuccess = new SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCertificateRequest> onError = new ErrorConsumer<CreateCertificateRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateCertificateDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCertificateRequest, CreateCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCertificateRequest> onError = handler == null ? null : new ErrorConsumer<CreateCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCertificateDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateCertificateDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCustomProtectionRuleResponse> createCustomProtectionRule(CreateCustomProtectionRuleRequest request, AsyncHandler<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async createCustomProtectionRule");
        final CreateCustomProtectionRuleRequest interceptedRequest = CreateCustomProtectionRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCustomProtectionRuleResponse> transformer = CreateCustomProtectionRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse> onSuccess = new SuccessConsumer<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCustomProtectionRuleRequest> onError = new ErrorConsumer<CreateCustomProtectionRuleRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateCustomProtectionRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCustomProtectionRuleRequest> onError = handler == null ? null : new ErrorConsumer<CreateCustomProtectionRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCustomProtectionRuleDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCustomProtectionRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateCustomProtectionRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCustomProtectionRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateWaasPolicyResponse> createWaasPolicy(CreateWaasPolicyRequest request, AsyncHandler<CreateWaasPolicyRequest, CreateWaasPolicyResponse> handler) {
        LOG.trace("Called async createWaasPolicy");
        final CreateWaasPolicyRequest interceptedRequest = CreateWaasPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateWaasPolicyResponse> transformer = CreateWaasPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateWaasPolicyRequest, CreateWaasPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateWaasPolicyRequest, CreateWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateWaasPolicyRequest, CreateWaasPolicyResponse> onSuccess = new SuccessConsumer<CreateWaasPolicyRequest, CreateWaasPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateWaasPolicyRequest> onError = new ErrorConsumer<CreateWaasPolicyRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateWaasPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateWaasPolicyRequest, CreateWaasPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateWaasPolicyRequest, CreateWaasPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateWaasPolicyRequest> onError = handler == null ? null : new ErrorConsumer<CreateWaasPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateWaasPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateWaasPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getCreateWaasPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateWaasPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAddressListResponse> deleteAddressList(DeleteAddressListRequest request, AsyncHandler<DeleteAddressListRequest, DeleteAddressListResponse> handler) {
        LOG.trace("Called async deleteAddressList");
        final DeleteAddressListRequest interceptedRequest = DeleteAddressListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAddressListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAddressListResponse> transformer = DeleteAddressListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAddressListRequest, DeleteAddressListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAddressListRequest, DeleteAddressListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAddressListRequest, DeleteAddressListResponse> onSuccess = new SuccessConsumer<DeleteAddressListRequest, DeleteAddressListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAddressListRequest> onError = new ErrorConsumer<DeleteAddressListRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAddressListRequest, DeleteAddressListResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAddressListRequest, DeleteAddressListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAddressListRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAddressListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAddressListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAddressListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        LOG.trace("Called async deleteCertificate");
        final DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse> onSuccess = new SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCertificateRequest> onError = new ErrorConsumer<DeleteCertificateRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCertificateRequest, DeleteCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCertificateRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCustomProtectionRuleResponse> deleteCustomProtectionRule(DeleteCustomProtectionRuleRequest request, AsyncHandler<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async deleteCustomProtectionRule");
        final DeleteCustomProtectionRuleRequest interceptedRequest = DeleteCustomProtectionRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCustomProtectionRuleResponse> transformer = DeleteCustomProtectionRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse> onSuccess = new SuccessConsumer<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCustomProtectionRuleRequest> onError = new ErrorConsumer<DeleteCustomProtectionRuleRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCustomProtectionRuleRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCustomProtectionRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCustomProtectionRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCustomProtectionRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteWaasPolicyResponse> deleteWaasPolicy(DeleteWaasPolicyRequest request, AsyncHandler<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse> handler) {
        LOG.trace("Called async deleteWaasPolicy");
        final DeleteWaasPolicyRequest interceptedRequest = DeleteWaasPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteWaasPolicyResponse> transformer = DeleteWaasPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse> onSuccess = new SuccessConsumer<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteWaasPolicyRequest> onError = new ErrorConsumer<DeleteWaasPolicyRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteWaasPolicyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteWaasPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteWaasPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteWaasPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAddressListResponse> getAddressList(GetAddressListRequest request, AsyncHandler<GetAddressListRequest, GetAddressListResponse> handler) {
        LOG.trace("Called async getAddressList");
        final GetAddressListRequest interceptedRequest = GetAddressListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAddressListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAddressListResponse> transformer = GetAddressListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAddressListRequest, GetAddressListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAddressListRequest, GetAddressListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAddressListRequest, GetAddressListResponse> onSuccess = new SuccessConsumer<GetAddressListRequest, GetAddressListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAddressListRequest> onError = new ErrorConsumer<GetAddressListRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAddressListRequest, GetAddressListResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAddressListRequest, GetAddressListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAddressListRequest> onError = handler == null ? null : new ErrorConsumer<GetAddressListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAddressListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAddressListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCertificateResponse> getCertificate(GetCertificateRequest request, AsyncHandler<GetCertificateRequest, GetCertificateResponse> handler) {
        LOG.trace("Called async getCertificate");
        final GetCertificateRequest interceptedRequest = GetCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCertificateResponse> transformer = GetCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCertificateRequest, GetCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCertificateRequest, GetCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCertificateRequest, GetCertificateResponse> onSuccess = new SuccessConsumer<GetCertificateRequest, GetCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCertificateRequest> onError = new ErrorConsumer<GetCertificateRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCertificateRequest, GetCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCertificateRequest, GetCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCertificateRequest> onError = handler == null ? null : new ErrorConsumer<GetCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCustomProtectionRuleResponse> getCustomProtectionRule(GetCustomProtectionRuleRequest request, AsyncHandler<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async getCustomProtectionRule");
        final GetCustomProtectionRuleRequest interceptedRequest = GetCustomProtectionRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCustomProtectionRuleResponse> transformer = GetCustomProtectionRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> onSuccess = new SuccessConsumer<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCustomProtectionRuleRequest> onError = new ErrorConsumer<GetCustomProtectionRuleRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCustomProtectionRuleRequest> onError = handler == null ? null : new ErrorConsumer<GetCustomProtectionRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCustomProtectionRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCustomProtectionRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDeviceFingerprintChallengeResponse> getDeviceFingerprintChallenge(GetDeviceFingerprintChallengeRequest request, AsyncHandler<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse> handler) {
        LOG.trace("Called async getDeviceFingerprintChallenge");
        final GetDeviceFingerprintChallengeRequest interceptedRequest = GetDeviceFingerprintChallengeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDeviceFingerprintChallengeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDeviceFingerprintChallengeResponse> transformer = GetDeviceFingerprintChallengeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse> onSuccess = new SuccessConsumer<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDeviceFingerprintChallengeRequest> onError = new ErrorConsumer<GetDeviceFingerprintChallengeRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDeviceFingerprintChallengeRequest> onError = handler == null ? null : new ErrorConsumer<GetDeviceFingerprintChallengeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDeviceFingerprintChallengeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDeviceFingerprintChallengeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetHumanInteractionChallengeResponse> getHumanInteractionChallenge(GetHumanInteractionChallengeRequest request, AsyncHandler<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse> handler) {
        LOG.trace("Called async getHumanInteractionChallenge");
        final GetHumanInteractionChallengeRequest interceptedRequest = GetHumanInteractionChallengeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetHumanInteractionChallengeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetHumanInteractionChallengeResponse> transformer = GetHumanInteractionChallengeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse> onSuccess = new SuccessConsumer<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetHumanInteractionChallengeRequest> onError = new ErrorConsumer<GetHumanInteractionChallengeRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetHumanInteractionChallengeRequest> onError = handler == null ? null : new ErrorConsumer<GetHumanInteractionChallengeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetHumanInteractionChallengeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetHumanInteractionChallengeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetJsChallengeResponse> getJsChallenge(GetJsChallengeRequest request, AsyncHandler<GetJsChallengeRequest, GetJsChallengeResponse> handler) {
        LOG.trace("Called async getJsChallenge");
        final GetJsChallengeRequest interceptedRequest = GetJsChallengeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetJsChallengeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetJsChallengeResponse> transformer = GetJsChallengeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetJsChallengeRequest, GetJsChallengeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetJsChallengeRequest, GetJsChallengeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetJsChallengeRequest, GetJsChallengeResponse> onSuccess = new SuccessConsumer<GetJsChallengeRequest, GetJsChallengeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetJsChallengeRequest> onError = new ErrorConsumer<GetJsChallengeRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetJsChallengeRequest, GetJsChallengeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetJsChallengeRequest, GetJsChallengeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetJsChallengeRequest> onError = handler == null ? null : new ErrorConsumer<GetJsChallengeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetJsChallengeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetJsChallengeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPolicyConfigResponse> getPolicyConfig(GetPolicyConfigRequest request, AsyncHandler<GetPolicyConfigRequest, GetPolicyConfigResponse> handler) {
        LOG.trace("Called async getPolicyConfig");
        final GetPolicyConfigRequest interceptedRequest = GetPolicyConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPolicyConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPolicyConfigResponse> transformer = GetPolicyConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPolicyConfigRequest, GetPolicyConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPolicyConfigRequest, GetPolicyConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPolicyConfigRequest, GetPolicyConfigResponse> onSuccess = new SuccessConsumer<GetPolicyConfigRequest, GetPolicyConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPolicyConfigRequest> onError = new ErrorConsumer<GetPolicyConfigRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPolicyConfigRequest, GetPolicyConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPolicyConfigRequest, GetPolicyConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPolicyConfigRequest> onError = handler == null ? null : new ErrorConsumer<GetPolicyConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPolicyConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPolicyConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetProtectionRuleResponse> getProtectionRule(GetProtectionRuleRequest request, AsyncHandler<GetProtectionRuleRequest, GetProtectionRuleResponse> handler) {
        LOG.trace("Called async getProtectionRule");
        final GetProtectionRuleRequest interceptedRequest = GetProtectionRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetProtectionRuleResponse> transformer = GetProtectionRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetProtectionRuleRequest, GetProtectionRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetProtectionRuleRequest, GetProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetProtectionRuleRequest, GetProtectionRuleResponse> onSuccess = new SuccessConsumer<GetProtectionRuleRequest, GetProtectionRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetProtectionRuleRequest> onError = new ErrorConsumer<GetProtectionRuleRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetProtectionRuleRequest, GetProtectionRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetProtectionRuleRequest, GetProtectionRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetProtectionRuleRequest> onError = handler == null ? null : new ErrorConsumer<GetProtectionRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetProtectionRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetProtectionRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetProtectionSettingsResponse> getProtectionSettings(GetProtectionSettingsRequest request, AsyncHandler<GetProtectionSettingsRequest, GetProtectionSettingsResponse> handler) {
        LOG.trace("Called async getProtectionSettings");
        final GetProtectionSettingsRequest interceptedRequest = GetProtectionSettingsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetProtectionSettingsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetProtectionSettingsResponse> transformer = GetProtectionSettingsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetProtectionSettingsRequest, GetProtectionSettingsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetProtectionSettingsRequest, GetProtectionSettingsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetProtectionSettingsRequest, GetProtectionSettingsResponse> onSuccess = new SuccessConsumer<GetProtectionSettingsRequest, GetProtectionSettingsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetProtectionSettingsRequest> onError = new ErrorConsumer<GetProtectionSettingsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetProtectionSettingsRequest, GetProtectionSettingsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetProtectionSettingsRequest, GetProtectionSettingsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetProtectionSettingsRequest> onError = handler == null ? null : new ErrorConsumer<GetProtectionSettingsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetProtectionSettingsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetProtectionSettingsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWaasPolicyResponse> getWaasPolicy(GetWaasPolicyRequest request, AsyncHandler<GetWaasPolicyRequest, GetWaasPolicyResponse> handler) {
        LOG.trace("Called async getWaasPolicy");
        final GetWaasPolicyRequest interceptedRequest = GetWaasPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWaasPolicyResponse> transformer = GetWaasPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWaasPolicyRequest, GetWaasPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWaasPolicyRequest, GetWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWaasPolicyRequest, GetWaasPolicyResponse> onSuccess = new SuccessConsumer<GetWaasPolicyRequest, GetWaasPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWaasPolicyRequest> onError = new ErrorConsumer<GetWaasPolicyRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWaasPolicyRequest, GetWaasPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWaasPolicyRequest, GetWaasPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWaasPolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetWaasPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWaasPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWaasPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWafAddressRateLimitingResponse> getWafAddressRateLimiting(GetWafAddressRateLimitingRequest request, AsyncHandler<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse> handler) {
        LOG.trace("Called async getWafAddressRateLimiting");
        final GetWafAddressRateLimitingRequest interceptedRequest = GetWafAddressRateLimitingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWafAddressRateLimitingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWafAddressRateLimitingResponse> transformer = GetWafAddressRateLimitingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse> onSuccess = new SuccessConsumer<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWafAddressRateLimitingRequest> onError = new ErrorConsumer<GetWafAddressRateLimitingRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWafAddressRateLimitingRequest> onError = handler == null ? null : new ErrorConsumer<GetWafAddressRateLimitingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWafAddressRateLimitingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWafAddressRateLimitingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWafConfigResponse> getWafConfig(GetWafConfigRequest request, AsyncHandler<GetWafConfigRequest, GetWafConfigResponse> handler) {
        LOG.trace("Called async getWafConfig");
        final GetWafConfigRequest interceptedRequest = GetWafConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWafConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWafConfigResponse> transformer = GetWafConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWafConfigRequest, GetWafConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWafConfigRequest, GetWafConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWafConfigRequest, GetWafConfigResponse> onSuccess = new SuccessConsumer<GetWafConfigRequest, GetWafConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWafConfigRequest> onError = new ErrorConsumer<GetWafConfigRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWafConfigRequest, GetWafConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWafConfigRequest, GetWafConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWafConfigRequest> onError = handler == null ? null : new ErrorConsumer<GetWafConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWafConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWafConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAccessRulesResponse> listAccessRules(ListAccessRulesRequest request, AsyncHandler<ListAccessRulesRequest, ListAccessRulesResponse> handler) {
        LOG.trace("Called async listAccessRules");
        final ListAccessRulesRequest interceptedRequest = ListAccessRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAccessRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAccessRulesResponse> transformer = ListAccessRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAccessRulesRequest, ListAccessRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAccessRulesRequest, ListAccessRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAccessRulesRequest, ListAccessRulesResponse> onSuccess = new SuccessConsumer<ListAccessRulesRequest, ListAccessRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAccessRulesRequest> onError = new ErrorConsumer<ListAccessRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAccessRulesRequest, ListAccessRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAccessRulesRequest, ListAccessRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAccessRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListAccessRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAccessRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAccessRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAddressListsResponse> listAddressLists(ListAddressListsRequest request, AsyncHandler<ListAddressListsRequest, ListAddressListsResponse> handler) {
        LOG.trace("Called async listAddressLists");
        final ListAddressListsRequest interceptedRequest = ListAddressListsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAddressListsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAddressListsResponse> transformer = ListAddressListsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAddressListsRequest, ListAddressListsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAddressListsRequest, ListAddressListsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAddressListsRequest, ListAddressListsResponse> onSuccess = new SuccessConsumer<ListAddressListsRequest, ListAddressListsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAddressListsRequest> onError = new ErrorConsumer<ListAddressListsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAddressListsRequest, ListAddressListsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAddressListsRequest, ListAddressListsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAddressListsRequest> onError = handler == null ? null : new ErrorConsumer<ListAddressListsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAddressListsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAddressListsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCachingRulesResponse> listCachingRules(ListCachingRulesRequest request, AsyncHandler<ListCachingRulesRequest, ListCachingRulesResponse> handler) {
        LOG.trace("Called async listCachingRules");
        final ListCachingRulesRequest interceptedRequest = ListCachingRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCachingRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCachingRulesResponse> transformer = ListCachingRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCachingRulesRequest, ListCachingRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCachingRulesRequest, ListCachingRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCachingRulesRequest, ListCachingRulesResponse> onSuccess = new SuccessConsumer<ListCachingRulesRequest, ListCachingRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCachingRulesRequest> onError = new ErrorConsumer<ListCachingRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCachingRulesRequest, ListCachingRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCachingRulesRequest, ListCachingRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCachingRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListCachingRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCachingRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCachingRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCaptchasResponse> listCaptchas(ListCaptchasRequest request, AsyncHandler<ListCaptchasRequest, ListCaptchasResponse> handler) {
        LOG.trace("Called async listCaptchas");
        final ListCaptchasRequest interceptedRequest = ListCaptchasConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCaptchasConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCaptchasResponse> transformer = ListCaptchasConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCaptchasRequest, ListCaptchasResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCaptchasRequest, ListCaptchasResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCaptchasRequest, ListCaptchasResponse> onSuccess = new SuccessConsumer<ListCaptchasRequest, ListCaptchasResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCaptchasRequest> onError = new ErrorConsumer<ListCaptchasRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCaptchasRequest, ListCaptchasResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCaptchasRequest, ListCaptchasResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCaptchasRequest> onError = handler == null ? null : new ErrorConsumer<ListCaptchasRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCaptchasResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCaptchasResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        LOG.trace("Called async listCertificates");
        final ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCertificatesRequest, ListCertificatesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse> onSuccess = new SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCertificatesRequest> onError = new ErrorConsumer<ListCertificatesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCertificatesRequest, ListCertificatesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCertificatesRequest> onError = handler == null ? null : new ErrorConsumer<ListCertificatesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCertificatesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCertificatesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCustomProtectionRulesResponse> listCustomProtectionRules(ListCustomProtectionRulesRequest request, AsyncHandler<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse> handler) {
        LOG.trace("Called async listCustomProtectionRules");
        final ListCustomProtectionRulesRequest interceptedRequest = ListCustomProtectionRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCustomProtectionRulesResponse> transformer = ListCustomProtectionRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse> onSuccess = new SuccessConsumer<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCustomProtectionRulesRequest> onError = new ErrorConsumer<ListCustomProtectionRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCustomProtectionRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListCustomProtectionRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCustomProtectionRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCustomProtectionRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListEdgeSubnetsResponse> listEdgeSubnets(ListEdgeSubnetsRequest request, AsyncHandler<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse> handler) {
        LOG.trace("Called async listEdgeSubnets");
        final ListEdgeSubnetsRequest interceptedRequest = ListEdgeSubnetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListEdgeSubnetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListEdgeSubnetsResponse> transformer = ListEdgeSubnetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse> onSuccess = new SuccessConsumer<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListEdgeSubnetsRequest> onError = new ErrorConsumer<ListEdgeSubnetsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListEdgeSubnetsRequest> onError = handler == null ? null : new ErrorConsumer<ListEdgeSubnetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListEdgeSubnetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListEdgeSubnetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListGoodBotsResponse> listGoodBots(ListGoodBotsRequest request, AsyncHandler<ListGoodBotsRequest, ListGoodBotsResponse> handler) {
        LOG.trace("Called async listGoodBots");
        final ListGoodBotsRequest interceptedRequest = ListGoodBotsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListGoodBotsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListGoodBotsResponse> transformer = ListGoodBotsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListGoodBotsRequest, ListGoodBotsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListGoodBotsRequest, ListGoodBotsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListGoodBotsRequest, ListGoodBotsResponse> onSuccess = new SuccessConsumer<ListGoodBotsRequest, ListGoodBotsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListGoodBotsRequest> onError = new ErrorConsumer<ListGoodBotsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListGoodBotsRequest, ListGoodBotsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListGoodBotsRequest, ListGoodBotsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListGoodBotsRequest> onError = handler == null ? null : new ErrorConsumer<ListGoodBotsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListGoodBotsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListGoodBotsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListProtectionRulesResponse> listProtectionRules(ListProtectionRulesRequest request, AsyncHandler<ListProtectionRulesRequest, ListProtectionRulesResponse> handler) {
        LOG.trace("Called async listProtectionRules");
        final ListProtectionRulesRequest interceptedRequest = ListProtectionRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListProtectionRulesResponse> transformer = ListProtectionRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListProtectionRulesRequest, ListProtectionRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListProtectionRulesRequest, ListProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListProtectionRulesRequest, ListProtectionRulesResponse> onSuccess = new SuccessConsumer<ListProtectionRulesRequest, ListProtectionRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListProtectionRulesRequest> onError = new ErrorConsumer<ListProtectionRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListProtectionRulesRequest, ListProtectionRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListProtectionRulesRequest, ListProtectionRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListProtectionRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListProtectionRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListProtectionRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListProtectionRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRecommendationsResponse> listRecommendations(ListRecommendationsRequest request, AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handler) {
        LOG.trace("Called async listRecommendations");
        final ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRecommendationsRequest, ListRecommendationsResponse> onSuccess = new SuccessConsumer<ListRecommendationsRequest, ListRecommendationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRecommendationsRequest> onError = new ErrorConsumer<ListRecommendationsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRecommendationsRequest, ListRecommendationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRecommendationsRequest, ListRecommendationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRecommendationsRequest> onError = handler == null ? null : new ErrorConsumer<ListRecommendationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRecommendationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRecommendationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListThreatFeedsResponse> listThreatFeeds(ListThreatFeedsRequest request, AsyncHandler<ListThreatFeedsRequest, ListThreatFeedsResponse> handler) {
        LOG.trace("Called async listThreatFeeds");
        final ListThreatFeedsRequest interceptedRequest = ListThreatFeedsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListThreatFeedsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListThreatFeedsResponse> transformer = ListThreatFeedsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListThreatFeedsRequest, ListThreatFeedsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListThreatFeedsRequest, ListThreatFeedsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListThreatFeedsRequest, ListThreatFeedsResponse> onSuccess = new SuccessConsumer<ListThreatFeedsRequest, ListThreatFeedsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListThreatFeedsRequest> onError = new ErrorConsumer<ListThreatFeedsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListThreatFeedsRequest, ListThreatFeedsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListThreatFeedsRequest, ListThreatFeedsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListThreatFeedsRequest> onError = handler == null ? null : new ErrorConsumer<ListThreatFeedsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListThreatFeedsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListThreatFeedsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWaasPoliciesResponse> listWaasPolicies(ListWaasPoliciesRequest request, AsyncHandler<ListWaasPoliciesRequest, ListWaasPoliciesResponse> handler) {
        LOG.trace("Called async listWaasPolicies");
        final ListWaasPoliciesRequest interceptedRequest = ListWaasPoliciesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWaasPoliciesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWaasPoliciesResponse> transformer = ListWaasPoliciesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWaasPoliciesRequest, ListWaasPoliciesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWaasPoliciesRequest, ListWaasPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWaasPoliciesRequest, ListWaasPoliciesResponse> onSuccess = new SuccessConsumer<ListWaasPoliciesRequest, ListWaasPoliciesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWaasPoliciesRequest> onError = new ErrorConsumer<ListWaasPoliciesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWaasPoliciesRequest, ListWaasPoliciesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWaasPoliciesRequest, ListWaasPoliciesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWaasPoliciesRequest> onError = handler == null ? null : new ErrorConsumer<ListWaasPoliciesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWaasPoliciesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWaasPoliciesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWaasPolicyCustomProtectionRulesResponse> listWaasPolicyCustomProtectionRules(ListWaasPolicyCustomProtectionRulesRequest request, AsyncHandler<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse> handler) {
        LOG.trace("Called async listWaasPolicyCustomProtectionRules");
        final ListWaasPolicyCustomProtectionRulesRequest interceptedRequest = ListWaasPolicyCustomProtectionRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWaasPolicyCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWaasPolicyCustomProtectionRulesResponse> transformer = ListWaasPolicyCustomProtectionRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse> onSuccess = new SuccessConsumer<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWaasPolicyCustomProtectionRulesRequest> onError = new ErrorConsumer<ListWaasPolicyCustomProtectionRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWaasPolicyCustomProtectionRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListWaasPolicyCustomProtectionRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWaasPolicyCustomProtectionRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWaasPolicyCustomProtectionRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWafBlockedRequestsResponse> listWafBlockedRequests(ListWafBlockedRequestsRequest request, AsyncHandler<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse> handler) {
        LOG.trace("Called async listWafBlockedRequests");
        final ListWafBlockedRequestsRequest interceptedRequest = ListWafBlockedRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWafBlockedRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWafBlockedRequestsResponse> transformer = ListWafBlockedRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse> onSuccess = new SuccessConsumer<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWafBlockedRequestsRequest> onError = new ErrorConsumer<ListWafBlockedRequestsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWafBlockedRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWafBlockedRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWafBlockedRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWafBlockedRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWafLogsResponse> listWafLogs(ListWafLogsRequest request, AsyncHandler<ListWafLogsRequest, ListWafLogsResponse> handler) {
        LOG.trace("Called async listWafLogs");
        final ListWafLogsRequest interceptedRequest = ListWafLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWafLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWafLogsResponse> transformer = ListWafLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWafLogsRequest, ListWafLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWafLogsRequest, ListWafLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWafLogsRequest, ListWafLogsResponse> onSuccess = new SuccessConsumer<ListWafLogsRequest, ListWafLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWafLogsRequest> onError = new ErrorConsumer<ListWafLogsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWafLogsRequest, ListWafLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWafLogsRequest, ListWafLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWafLogsRequest> onError = handler == null ? null : new ErrorConsumer<ListWafLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWafLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWafLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWafRequestsResponse> listWafRequests(ListWafRequestsRequest request, AsyncHandler<ListWafRequestsRequest, ListWafRequestsResponse> handler) {
        LOG.trace("Called async listWafRequests");
        final ListWafRequestsRequest interceptedRequest = ListWafRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWafRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWafRequestsResponse> transformer = ListWafRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWafRequestsRequest, ListWafRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWafRequestsRequest, ListWafRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWafRequestsRequest, ListWafRequestsResponse> onSuccess = new SuccessConsumer<ListWafRequestsRequest, ListWafRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWafRequestsRequest> onError = new ErrorConsumer<ListWafRequestsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWafRequestsRequest, ListWafRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWafRequestsRequest, ListWafRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWafRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWafRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWafRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWafRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWafTrafficResponse> listWafTraffic(ListWafTrafficRequest request, AsyncHandler<ListWafTrafficRequest, ListWafTrafficResponse> handler) {
        LOG.trace("Called async listWafTraffic");
        final ListWafTrafficRequest interceptedRequest = ListWafTrafficConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWafTrafficConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWafTrafficResponse> transformer = ListWafTrafficConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWafTrafficRequest, ListWafTrafficResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWafTrafficRequest, ListWafTrafficResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWafTrafficRequest, ListWafTrafficResponse> onSuccess = new SuccessConsumer<ListWafTrafficRequest, ListWafTrafficResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWafTrafficRequest> onError = new ErrorConsumer<ListWafTrafficRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWafTrafficRequest, ListWafTrafficResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWafTrafficRequest, ListWafTrafficResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWafTrafficRequest> onError = handler == null ? null : new ErrorConsumer<ListWafTrafficRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWafTrafficResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWafTrafficResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWhitelistsResponse> listWhitelists(ListWhitelistsRequest request, AsyncHandler<ListWhitelistsRequest, ListWhitelistsResponse> handler) {
        LOG.trace("Called async listWhitelists");
        final ListWhitelistsRequest interceptedRequest = ListWhitelistsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWhitelistsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWhitelistsResponse> transformer = ListWhitelistsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWhitelistsRequest, ListWhitelistsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWhitelistsRequest, ListWhitelistsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWhitelistsRequest, ListWhitelistsResponse> onSuccess = new SuccessConsumer<ListWhitelistsRequest, ListWhitelistsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWhitelistsRequest> onError = new ErrorConsumer<ListWhitelistsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWhitelistsRequest, ListWhitelistsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWhitelistsRequest, ListWhitelistsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWhitelistsRequest> onError = handler == null ? null : new ErrorConsumer<ListWhitelistsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWhitelistsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWhitelistsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PurgeCacheResponse> purgeCache(PurgeCacheRequest request, AsyncHandler<PurgeCacheRequest, PurgeCacheResponse> handler) {
        LOG.trace("Called async purgeCache");
        final PurgeCacheRequest interceptedRequest = PurgeCacheConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PurgeCacheConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PurgeCacheResponse> transformer = PurgeCacheConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PurgeCacheRequest, PurgeCacheResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PurgeCacheRequest, PurgeCacheResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PurgeCacheRequest, PurgeCacheResponse> onSuccess = new SuccessConsumer<PurgeCacheRequest, PurgeCacheResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PurgeCacheRequest> onError = new ErrorConsumer<PurgeCacheRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.post(ib, interceptedRequest.getPurgeCache(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PurgeCacheRequest, PurgeCacheResponse> onSuccess = handler == null ? null : new SuccessConsumer<PurgeCacheRequest, PurgeCacheResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PurgeCacheRequest> onError = handler == null ? null : new ErrorConsumer<PurgeCacheRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getPurgeCache(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PurgeCacheResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.post(ib, interceptedRequest.getPurgeCache(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PurgeCacheResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAccessRulesResponse> updateAccessRules(UpdateAccessRulesRequest request, AsyncHandler<UpdateAccessRulesRequest, UpdateAccessRulesResponse> handler) {
        LOG.trace("Called async updateAccessRules");
        final UpdateAccessRulesRequest interceptedRequest = UpdateAccessRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAccessRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAccessRulesResponse> transformer = UpdateAccessRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAccessRulesRequest, UpdateAccessRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAccessRulesRequest, UpdateAccessRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAccessRulesRequest, UpdateAccessRulesResponse> onSuccess = new SuccessConsumer<UpdateAccessRulesRequest, UpdateAccessRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAccessRulesRequest> onError = new ErrorConsumer<UpdateAccessRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getAccessRules(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAccessRulesRequest, UpdateAccessRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAccessRulesRequest, UpdateAccessRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAccessRulesRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAccessRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getAccessRules(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAccessRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getAccessRules(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAccessRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAddressListResponse> updateAddressList(UpdateAddressListRequest request, AsyncHandler<UpdateAddressListRequest, UpdateAddressListResponse> handler) {
        LOG.trace("Called async updateAddressList");
        final UpdateAddressListRequest interceptedRequest = UpdateAddressListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAddressListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAddressListResponse> transformer = UpdateAddressListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAddressListRequest, UpdateAddressListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAddressListRequest, UpdateAddressListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAddressListRequest, UpdateAddressListResponse> onSuccess = new SuccessConsumer<UpdateAddressListRequest, UpdateAddressListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAddressListRequest> onError = new ErrorConsumer<UpdateAddressListRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAddressListDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAddressListRequest, UpdateAddressListResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAddressListRequest, UpdateAddressListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAddressListRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAddressListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAddressListDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAddressListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAddressListDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAddressListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCachingRulesResponse> updateCachingRules(UpdateCachingRulesRequest request, AsyncHandler<UpdateCachingRulesRequest, UpdateCachingRulesResponse> handler) {
        LOG.trace("Called async updateCachingRules");
        final UpdateCachingRulesRequest interceptedRequest = UpdateCachingRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCachingRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCachingRulesResponse> transformer = UpdateCachingRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCachingRulesRequest, UpdateCachingRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCachingRulesRequest, UpdateCachingRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCachingRulesRequest, UpdateCachingRulesResponse> onSuccess = new SuccessConsumer<UpdateCachingRulesRequest, UpdateCachingRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCachingRulesRequest> onError = new ErrorConsumer<UpdateCachingRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getCachingRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCachingRulesRequest, UpdateCachingRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCachingRulesRequest, UpdateCachingRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCachingRulesRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCachingRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getCachingRulesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCachingRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getCachingRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCachingRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCaptchasResponse> updateCaptchas(UpdateCaptchasRequest request, AsyncHandler<UpdateCaptchasRequest, UpdateCaptchasResponse> handler) {
        LOG.trace("Called async updateCaptchas");
        final UpdateCaptchasRequest interceptedRequest = UpdateCaptchasConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCaptchasConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCaptchasResponse> transformer = UpdateCaptchasConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCaptchasRequest, UpdateCaptchasResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCaptchasRequest, UpdateCaptchasResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCaptchasRequest, UpdateCaptchasResponse> onSuccess = new SuccessConsumer<UpdateCaptchasRequest, UpdateCaptchasResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCaptchasRequest> onError = new ErrorConsumer<UpdateCaptchasRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getCaptchas(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCaptchasRequest, UpdateCaptchasResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCaptchasRequest, UpdateCaptchasResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCaptchasRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCaptchasRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getCaptchas(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCaptchasResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getCaptchas(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCaptchasResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request, AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handler) {
        LOG.trace("Called async updateCertificate");
        final UpdateCertificateRequest interceptedRequest = UpdateCertificateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCertificateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCertificateResponse> transformer = UpdateCertificateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCertificateRequest, UpdateCertificateResponse> onSuccess = new SuccessConsumer<UpdateCertificateRequest, UpdateCertificateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCertificateRequest> onError = new ErrorConsumer<UpdateCertificateRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCertificateDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCertificateRequest, UpdateCertificateResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCertificateRequest, UpdateCertificateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCertificateRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCertificateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCertificateDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCertificateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCertificateDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCertificateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCustomProtectionRuleResponse> updateCustomProtectionRule(UpdateCustomProtectionRuleRequest request, AsyncHandler<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async updateCustomProtectionRule");
        final UpdateCustomProtectionRuleRequest interceptedRequest = UpdateCustomProtectionRuleConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCustomProtectionRuleResponse> transformer = UpdateCustomProtectionRuleConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse> onSuccess = new SuccessConsumer<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCustomProtectionRuleRequest> onError = new ErrorConsumer<UpdateCustomProtectionRuleRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCustomProtectionRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCustomProtectionRuleRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCustomProtectionRuleRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCustomProtectionRuleDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCustomProtectionRuleResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCustomProtectionRuleDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCustomProtectionRuleResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDeviceFingerprintChallengeResponse> updateDeviceFingerprintChallenge(UpdateDeviceFingerprintChallengeRequest request, AsyncHandler<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse> handler) {
        LOG.trace("Called async updateDeviceFingerprintChallenge");
        final UpdateDeviceFingerprintChallengeRequest interceptedRequest = UpdateDeviceFingerprintChallengeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDeviceFingerprintChallengeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDeviceFingerprintChallengeResponse> transformer = UpdateDeviceFingerprintChallengeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse> onSuccess = new SuccessConsumer<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDeviceFingerprintChallengeRequest> onError = new ErrorConsumer<UpdateDeviceFingerprintChallengeRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDeviceFingerprintChallengeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDeviceFingerprintChallengeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDeviceFingerprintChallengeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDeviceFingerprintChallengeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDeviceFingerprintChallengeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDeviceFingerprintChallengeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDeviceFingerprintChallengeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateGoodBotsResponse> updateGoodBots(UpdateGoodBotsRequest request, AsyncHandler<UpdateGoodBotsRequest, UpdateGoodBotsResponse> handler) {
        LOG.trace("Called async updateGoodBots");
        final UpdateGoodBotsRequest interceptedRequest = UpdateGoodBotsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateGoodBotsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateGoodBotsResponse> transformer = UpdateGoodBotsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateGoodBotsRequest, UpdateGoodBotsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateGoodBotsRequest, UpdateGoodBotsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateGoodBotsRequest, UpdateGoodBotsResponse> onSuccess = new SuccessConsumer<UpdateGoodBotsRequest, UpdateGoodBotsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateGoodBotsRequest> onError = new ErrorConsumer<UpdateGoodBotsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getGoodBots(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateGoodBotsRequest, UpdateGoodBotsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateGoodBotsRequest, UpdateGoodBotsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateGoodBotsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateGoodBotsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getGoodBots(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateGoodBotsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getGoodBots(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateGoodBotsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateHumanInteractionChallengeResponse> updateHumanInteractionChallenge(UpdateHumanInteractionChallengeRequest request, AsyncHandler<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse> handler) {
        LOG.trace("Called async updateHumanInteractionChallenge");
        final UpdateHumanInteractionChallengeRequest interceptedRequest = UpdateHumanInteractionChallengeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateHumanInteractionChallengeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateHumanInteractionChallengeResponse> transformer = UpdateHumanInteractionChallengeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse> onSuccess = new SuccessConsumer<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateHumanInteractionChallengeRequest> onError = new ErrorConsumer<UpdateHumanInteractionChallengeRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateHumanInteractionChallengeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateHumanInteractionChallengeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateHumanInteractionChallengeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateHumanInteractionChallengeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateHumanInteractionChallengeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateHumanInteractionChallengeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateHumanInteractionChallengeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateJsChallengeResponse> updateJsChallenge(UpdateJsChallengeRequest request, AsyncHandler<UpdateJsChallengeRequest, UpdateJsChallengeResponse> handler) {
        LOG.trace("Called async updateJsChallenge");
        final UpdateJsChallengeRequest interceptedRequest = UpdateJsChallengeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateJsChallengeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateJsChallengeResponse> transformer = UpdateJsChallengeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateJsChallengeRequest, UpdateJsChallengeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateJsChallengeRequest, UpdateJsChallengeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateJsChallengeRequest, UpdateJsChallengeResponse> onSuccess = new SuccessConsumer<UpdateJsChallengeRequest, UpdateJsChallengeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateJsChallengeRequest> onError = new ErrorConsumer<UpdateJsChallengeRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateJsChallengeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateJsChallengeRequest, UpdateJsChallengeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateJsChallengeRequest, UpdateJsChallengeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateJsChallengeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateJsChallengeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateJsChallengeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateJsChallengeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateJsChallengeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateJsChallengeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdatePolicyConfigResponse> updatePolicyConfig(UpdatePolicyConfigRequest request, AsyncHandler<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse> handler) {
        LOG.trace("Called async updatePolicyConfig");
        final UpdatePolicyConfigRequest interceptedRequest = UpdatePolicyConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdatePolicyConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdatePolicyConfigResponse> transformer = UpdatePolicyConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse> onSuccess = new SuccessConsumer<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdatePolicyConfigRequest> onError = new ErrorConsumer<UpdatePolicyConfigRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePolicyConfigDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdatePolicyConfigRequest> onError = handler == null ? null : new ErrorConsumer<UpdatePolicyConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdatePolicyConfigDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdatePolicyConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePolicyConfigDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdatePolicyConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateProtectionRulesResponse> updateProtectionRules(UpdateProtectionRulesRequest request, AsyncHandler<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse> handler) {
        LOG.trace("Called async updateProtectionRules");
        final UpdateProtectionRulesRequest interceptedRequest = UpdateProtectionRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateProtectionRulesResponse> transformer = UpdateProtectionRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse> onSuccess = new SuccessConsumer<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateProtectionRulesRequest> onError = new ErrorConsumer<UpdateProtectionRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getProtectionRules(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateProtectionRulesRequest> onError = handler == null ? null : new ErrorConsumer<UpdateProtectionRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getProtectionRules(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateProtectionRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getProtectionRules(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateProtectionRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateProtectionSettingsResponse> updateProtectionSettings(UpdateProtectionSettingsRequest request, AsyncHandler<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse> handler) {
        LOG.trace("Called async updateProtectionSettings");
        final UpdateProtectionSettingsRequest interceptedRequest = UpdateProtectionSettingsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateProtectionSettingsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateProtectionSettingsResponse> transformer = UpdateProtectionSettingsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse> onSuccess = new SuccessConsumer<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateProtectionSettingsRequest> onError = new ErrorConsumer<UpdateProtectionSettingsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateProtectionSettingsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateProtectionSettingsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateProtectionSettingsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateProtectionSettingsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateProtectionSettingsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateProtectionSettingsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateProtectionSettingsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateThreatFeedsResponse> updateThreatFeeds(UpdateThreatFeedsRequest request, AsyncHandler<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse> handler) {
        LOG.trace("Called async updateThreatFeeds");
        final UpdateThreatFeedsRequest interceptedRequest = UpdateThreatFeedsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateThreatFeedsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateThreatFeedsResponse> transformer = UpdateThreatFeedsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse> onSuccess = new SuccessConsumer<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateThreatFeedsRequest> onError = new ErrorConsumer<UpdateThreatFeedsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getThreatFeeds(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateThreatFeedsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateThreatFeedsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getThreatFeeds(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateThreatFeedsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getThreatFeeds(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateThreatFeedsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateWaasPolicyResponse> updateWaasPolicy(UpdateWaasPolicyRequest request, AsyncHandler<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse> handler) {
        LOG.trace("Called async updateWaasPolicy");
        final UpdateWaasPolicyRequest interceptedRequest = UpdateWaasPolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateWaasPolicyResponse> transformer = UpdateWaasPolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse> onSuccess = new SuccessConsumer<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateWaasPolicyRequest> onError = new ErrorConsumer<UpdateWaasPolicyRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateWaasPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateWaasPolicyRequest> onError = handler == null ? null : new ErrorConsumer<UpdateWaasPolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateWaasPolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateWaasPolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateWaasPolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateWaasPolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateWaasPolicyCustomProtectionRulesResponse> updateWaasPolicyCustomProtectionRules(UpdateWaasPolicyCustomProtectionRulesRequest request, AsyncHandler<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse> handler) {
        LOG.trace("Called async updateWaasPolicyCustomProtectionRules");
        final UpdateWaasPolicyCustomProtectionRulesRequest interceptedRequest = UpdateWaasPolicyCustomProtectionRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateWaasPolicyCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateWaasPolicyCustomProtectionRulesResponse> transformer = UpdateWaasPolicyCustomProtectionRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse> onSuccess = new SuccessConsumer<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateWaasPolicyCustomProtectionRulesRequest> onError = new ErrorConsumer<UpdateWaasPolicyCustomProtectionRulesRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCustomProtectionRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateWaasPolicyCustomProtectionRulesRequest> onError = handler == null ? null : new ErrorConsumer<UpdateWaasPolicyCustomProtectionRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCustomProtectionRulesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateWaasPolicyCustomProtectionRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCustomProtectionRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateWaasPolicyCustomProtectionRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateWafAddressRateLimitingResponse> updateWafAddressRateLimiting(UpdateWafAddressRateLimitingRequest request, AsyncHandler<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse> handler) {
        LOG.trace("Called async updateWafAddressRateLimiting");
        final UpdateWafAddressRateLimitingRequest interceptedRequest = UpdateWafAddressRateLimitingConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateWafAddressRateLimitingConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateWafAddressRateLimitingResponse> transformer = UpdateWafAddressRateLimitingConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse> onSuccess = new SuccessConsumer<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateWafAddressRateLimitingRequest> onError = new ErrorConsumer<UpdateWafAddressRateLimitingRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateWafAddressRateLimitingDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateWafAddressRateLimitingRequest> onError = handler == null ? null : new ErrorConsumer<UpdateWafAddressRateLimitingRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateWafAddressRateLimitingDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateWafAddressRateLimitingResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateWafAddressRateLimitingDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateWafAddressRateLimitingResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateWafConfigResponse> updateWafConfig(UpdateWafConfigRequest request, AsyncHandler<UpdateWafConfigRequest, UpdateWafConfigResponse> handler) {
        LOG.trace("Called async updateWafConfig");
        final UpdateWafConfigRequest interceptedRequest = UpdateWafConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateWafConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateWafConfigResponse> transformer = UpdateWafConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateWafConfigRequest, UpdateWafConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateWafConfigRequest, UpdateWafConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateWafConfigRequest, UpdateWafConfigResponse> onSuccess = new SuccessConsumer<UpdateWafConfigRequest, UpdateWafConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateWafConfigRequest> onError = new ErrorConsumer<UpdateWafConfigRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateWafConfigDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateWafConfigRequest, UpdateWafConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateWafConfigRequest, UpdateWafConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateWafConfigRequest> onError = handler == null ? null : new ErrorConsumer<UpdateWafConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateWafConfigDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateWafConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getUpdateWafConfigDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateWafConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateWhitelistsResponse> updateWhitelists(UpdateWhitelistsRequest request, AsyncHandler<UpdateWhitelistsRequest, UpdateWhitelistsResponse> handler) {
        LOG.trace("Called async updateWhitelists");
        final UpdateWhitelistsRequest interceptedRequest = UpdateWhitelistsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateWhitelistsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateWhitelistsResponse> transformer = UpdateWhitelistsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateWhitelistsRequest, UpdateWhitelistsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateWhitelistsRequest, UpdateWhitelistsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateWhitelistsRequest, UpdateWhitelistsResponse> onSuccess = new SuccessConsumer<UpdateWhitelistsRequest, UpdateWhitelistsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateWhitelistsRequest> onError = new ErrorConsumer<UpdateWhitelistsRequest>(this, interceptedRequest);
                    WaasAsyncClient.this.client.put(ib, interceptedRequest.getWhitelists(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateWhitelistsRequest, UpdateWhitelistsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateWhitelistsRequest, UpdateWhitelistsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateWhitelistsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateWhitelistsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getWhitelists(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateWhitelistsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return WaasAsyncClient.this.client.put(ib, interceptedRequest.getWhitelists(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateWhitelistsResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WaasAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public WaasAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new WaasAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

