/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.waas.Waas;
import com.oracle.bmc.waas.model.AccessRule;
import com.oracle.bmc.waas.model.AddressListSummary;
import com.oracle.bmc.waas.model.CachingRuleSummary;
import com.oracle.bmc.waas.model.Captcha;
import com.oracle.bmc.waas.model.CertificateSummary;
import com.oracle.bmc.waas.model.CustomProtectionRuleSummary;
import com.oracle.bmc.waas.model.EdgeSubnet;
import com.oracle.bmc.waas.model.GoodBot;
import com.oracle.bmc.waas.model.ProtectionRule;
import com.oracle.bmc.waas.model.Recommendation;
import com.oracle.bmc.waas.model.ThreatFeed;
import com.oracle.bmc.waas.model.WaasPolicyCustomProtectionRuleSummary;
import com.oracle.bmc.waas.model.WaasPolicySummary;
import com.oracle.bmc.waas.model.WafBlockedRequest;
import com.oracle.bmc.waas.model.WafLog;
import com.oracle.bmc.waas.model.WafRequest;
import com.oracle.bmc.waas.model.WafTrafficDatum;
import com.oracle.bmc.waas.model.Whitelist;
import com.oracle.bmc.waas.model.WorkRequestSummary;
import com.oracle.bmc.waas.requests.ListAccessRulesRequest;
import com.oracle.bmc.waas.requests.ListAddressListsRequest;
import com.oracle.bmc.waas.requests.ListCachingRulesRequest;
import com.oracle.bmc.waas.requests.ListCaptchasRequest;
import com.oracle.bmc.waas.requests.ListCertificatesRequest;
import com.oracle.bmc.waas.requests.ListCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListEdgeSubnetsRequest;
import com.oracle.bmc.waas.requests.ListGoodBotsRequest;
import com.oracle.bmc.waas.requests.ListProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListRecommendationsRequest;
import com.oracle.bmc.waas.requests.ListThreatFeedsRequest;
import com.oracle.bmc.waas.requests.ListWaasPoliciesRequest;
import com.oracle.bmc.waas.requests.ListWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListWafBlockedRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.requests.ListWafRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafTrafficRequest;
import com.oracle.bmc.waas.requests.ListWhitelistsRequest;
import com.oracle.bmc.waas.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waas.responses.ListAccessRulesResponse;
import com.oracle.bmc.waas.responses.ListAddressListsResponse;
import com.oracle.bmc.waas.responses.ListCachingRulesResponse;
import com.oracle.bmc.waas.responses.ListCaptchasResponse;
import com.oracle.bmc.waas.responses.ListCertificatesResponse;
import com.oracle.bmc.waas.responses.ListCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListEdgeSubnetsResponse;
import com.oracle.bmc.waas.responses.ListGoodBotsResponse;
import com.oracle.bmc.waas.responses.ListProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListRecommendationsResponse;
import com.oracle.bmc.waas.responses.ListThreatFeedsResponse;
import com.oracle.bmc.waas.responses.ListWaasPoliciesResponse;
import com.oracle.bmc.waas.responses.ListWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListWafBlockedRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import com.oracle.bmc.waas.responses.ListWafRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafTrafficResponse;
import com.oracle.bmc.waas.responses.ListWhitelistsResponse;
import com.oracle.bmc.waas.responses.ListWorkRequestsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class WaasPaginators {
    private final Waas client;

    public Iterable<ListAccessRulesResponse> listAccessRulesResponseIterator(final ListAccessRulesRequest request) {
        return new ResponseIterable<ListAccessRulesRequest.Builder, ListAccessRulesRequest, ListAccessRulesResponse>(new Supplier<ListAccessRulesRequest.Builder>(){

            public ListAccessRulesRequest.Builder get() {
                return ListAccessRulesRequest.builder().copy(request);
            }
        }, new Function<ListAccessRulesResponse, String>(){

            public String apply(ListAccessRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAccessRulesRequest.Builder>, ListAccessRulesRequest>(){

            public ListAccessRulesRequest apply(RequestBuilderAndToken<ListAccessRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAccessRulesRequest, ListAccessRulesResponse>(){

            public ListAccessRulesResponse apply(ListAccessRulesRequest request) {
                return WaasPaginators.this.client.listAccessRules(request);
            }
        });
    }

    public Iterable<AccessRule> listAccessRulesRecordIterator(final ListAccessRulesRequest request) {
        return new ResponseRecordIterable<ListAccessRulesRequest.Builder, ListAccessRulesRequest, ListAccessRulesResponse, AccessRule>(new Supplier<ListAccessRulesRequest.Builder>(){

            public ListAccessRulesRequest.Builder get() {
                return ListAccessRulesRequest.builder().copy(request);
            }
        }, new Function<ListAccessRulesResponse, String>(){

            public String apply(ListAccessRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAccessRulesRequest.Builder>, ListAccessRulesRequest>(){

            public ListAccessRulesRequest apply(RequestBuilderAndToken<ListAccessRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAccessRulesRequest, ListAccessRulesResponse>(){

            public ListAccessRulesResponse apply(ListAccessRulesRequest request) {
                return WaasPaginators.this.client.listAccessRules(request);
            }
        }, new Function<ListAccessRulesResponse, List<AccessRule>>(){

            public List<AccessRule> apply(ListAccessRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAddressListsResponse> listAddressListsResponseIterator(final ListAddressListsRequest request) {
        return new ResponseIterable<ListAddressListsRequest.Builder, ListAddressListsRequest, ListAddressListsResponse>(new Supplier<ListAddressListsRequest.Builder>(){

            public ListAddressListsRequest.Builder get() {
                return ListAddressListsRequest.builder().copy(request);
            }
        }, new Function<ListAddressListsResponse, String>(){

            public String apply(ListAddressListsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAddressListsRequest.Builder>, ListAddressListsRequest>(){

            public ListAddressListsRequest apply(RequestBuilderAndToken<ListAddressListsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAddressListsRequest, ListAddressListsResponse>(){

            public ListAddressListsResponse apply(ListAddressListsRequest request) {
                return WaasPaginators.this.client.listAddressLists(request);
            }
        });
    }

    public Iterable<AddressListSummary> listAddressListsRecordIterator(final ListAddressListsRequest request) {
        return new ResponseRecordIterable<ListAddressListsRequest.Builder, ListAddressListsRequest, ListAddressListsResponse, AddressListSummary>(new Supplier<ListAddressListsRequest.Builder>(){

            public ListAddressListsRequest.Builder get() {
                return ListAddressListsRequest.builder().copy(request);
            }
        }, new Function<ListAddressListsResponse, String>(){

            public String apply(ListAddressListsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAddressListsRequest.Builder>, ListAddressListsRequest>(){

            public ListAddressListsRequest apply(RequestBuilderAndToken<ListAddressListsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAddressListsRequest, ListAddressListsResponse>(){

            public ListAddressListsResponse apply(ListAddressListsRequest request) {
                return WaasPaginators.this.client.listAddressLists(request);
            }
        }, new Function<ListAddressListsResponse, List<AddressListSummary>>(){

            public List<AddressListSummary> apply(ListAddressListsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCachingRulesResponse> listCachingRulesResponseIterator(final ListCachingRulesRequest request) {
        return new ResponseIterable<ListCachingRulesRequest.Builder, ListCachingRulesRequest, ListCachingRulesResponse>(new Supplier<ListCachingRulesRequest.Builder>(){

            public ListCachingRulesRequest.Builder get() {
                return ListCachingRulesRequest.builder().copy(request);
            }
        }, new Function<ListCachingRulesResponse, String>(){

            public String apply(ListCachingRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCachingRulesRequest.Builder>, ListCachingRulesRequest>(){

            public ListCachingRulesRequest apply(RequestBuilderAndToken<ListCachingRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCachingRulesRequest, ListCachingRulesResponse>(){

            public ListCachingRulesResponse apply(ListCachingRulesRequest request) {
                return WaasPaginators.this.client.listCachingRules(request);
            }
        });
    }

    public Iterable<CachingRuleSummary> listCachingRulesRecordIterator(final ListCachingRulesRequest request) {
        return new ResponseRecordIterable<ListCachingRulesRequest.Builder, ListCachingRulesRequest, ListCachingRulesResponse, CachingRuleSummary>(new Supplier<ListCachingRulesRequest.Builder>(){

            public ListCachingRulesRequest.Builder get() {
                return ListCachingRulesRequest.builder().copy(request);
            }
        }, new Function<ListCachingRulesResponse, String>(){

            public String apply(ListCachingRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCachingRulesRequest.Builder>, ListCachingRulesRequest>(){

            public ListCachingRulesRequest apply(RequestBuilderAndToken<ListCachingRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCachingRulesRequest, ListCachingRulesResponse>(){

            public ListCachingRulesResponse apply(ListCachingRulesRequest request) {
                return WaasPaginators.this.client.listCachingRules(request);
            }
        }, new Function<ListCachingRulesResponse, List<CachingRuleSummary>>(){

            public List<CachingRuleSummary> apply(ListCachingRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCaptchasResponse> listCaptchasResponseIterator(final ListCaptchasRequest request) {
        return new ResponseIterable<ListCaptchasRequest.Builder, ListCaptchasRequest, ListCaptchasResponse>(new Supplier<ListCaptchasRequest.Builder>(){

            public ListCaptchasRequest.Builder get() {
                return ListCaptchasRequest.builder().copy(request);
            }
        }, new Function<ListCaptchasResponse, String>(){

            public String apply(ListCaptchasResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCaptchasRequest.Builder>, ListCaptchasRequest>(){

            public ListCaptchasRequest apply(RequestBuilderAndToken<ListCaptchasRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCaptchasRequest, ListCaptchasResponse>(){

            public ListCaptchasResponse apply(ListCaptchasRequest request) {
                return WaasPaginators.this.client.listCaptchas(request);
            }
        });
    }

    public Iterable<Captcha> listCaptchasRecordIterator(final ListCaptchasRequest request) {
        return new ResponseRecordIterable<ListCaptchasRequest.Builder, ListCaptchasRequest, ListCaptchasResponse, Captcha>(new Supplier<ListCaptchasRequest.Builder>(){

            public ListCaptchasRequest.Builder get() {
                return ListCaptchasRequest.builder().copy(request);
            }
        }, new Function<ListCaptchasResponse, String>(){

            public String apply(ListCaptchasResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCaptchasRequest.Builder>, ListCaptchasRequest>(){

            public ListCaptchasRequest apply(RequestBuilderAndToken<ListCaptchasRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCaptchasRequest, ListCaptchasResponse>(){

            public ListCaptchasResponse apply(ListCaptchasRequest request) {
                return WaasPaginators.this.client.listCaptchas(request);
            }
        }, new Function<ListCaptchasResponse, List<Captcha>>(){

            public List<Captcha> apply(ListCaptchasResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCertificatesResponse> listCertificatesResponseIterator(final ListCertificatesRequest request) {
        return new ResponseIterable<ListCertificatesRequest.Builder, ListCertificatesRequest, ListCertificatesResponse>(new Supplier<ListCertificatesRequest.Builder>(){

            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, new Function<ListCertificatesResponse, String>(){

            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return WaasPaginators.this.client.listCertificates(request);
            }
        });
    }

    public Iterable<CertificateSummary> listCertificatesRecordIterator(final ListCertificatesRequest request) {
        return new ResponseRecordIterable<ListCertificatesRequest.Builder, ListCertificatesRequest, ListCertificatesResponse, CertificateSummary>(new Supplier<ListCertificatesRequest.Builder>(){

            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, new Function<ListCertificatesResponse, String>(){

            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return WaasPaginators.this.client.listCertificates(request);
            }
        }, new Function<ListCertificatesResponse, List<CertificateSummary>>(){

            public List<CertificateSummary> apply(ListCertificatesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCustomProtectionRulesResponse> listCustomProtectionRulesResponseIterator(final ListCustomProtectionRulesRequest request) {
        return new ResponseIterable<ListCustomProtectionRulesRequest.Builder, ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>(new Supplier<ListCustomProtectionRulesRequest.Builder>(){

            public ListCustomProtectionRulesRequest.Builder get() {
                return ListCustomProtectionRulesRequest.builder().copy(request);
            }
        }, new Function<ListCustomProtectionRulesResponse, String>(){

            public String apply(ListCustomProtectionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCustomProtectionRulesRequest.Builder>, ListCustomProtectionRulesRequest>(){

            public ListCustomProtectionRulesRequest apply(RequestBuilderAndToken<ListCustomProtectionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>(){

            public ListCustomProtectionRulesResponse apply(ListCustomProtectionRulesRequest request) {
                return WaasPaginators.this.client.listCustomProtectionRules(request);
            }
        });
    }

    public Iterable<CustomProtectionRuleSummary> listCustomProtectionRulesRecordIterator(final ListCustomProtectionRulesRequest request) {
        return new ResponseRecordIterable<ListCustomProtectionRulesRequest.Builder, ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse, CustomProtectionRuleSummary>(new Supplier<ListCustomProtectionRulesRequest.Builder>(){

            public ListCustomProtectionRulesRequest.Builder get() {
                return ListCustomProtectionRulesRequest.builder().copy(request);
            }
        }, new Function<ListCustomProtectionRulesResponse, String>(){

            public String apply(ListCustomProtectionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCustomProtectionRulesRequest.Builder>, ListCustomProtectionRulesRequest>(){

            public ListCustomProtectionRulesRequest apply(RequestBuilderAndToken<ListCustomProtectionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>(){

            public ListCustomProtectionRulesResponse apply(ListCustomProtectionRulesRequest request) {
                return WaasPaginators.this.client.listCustomProtectionRules(request);
            }
        }, new Function<ListCustomProtectionRulesResponse, List<CustomProtectionRuleSummary>>(){

            public List<CustomProtectionRuleSummary> apply(ListCustomProtectionRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListEdgeSubnetsResponse> listEdgeSubnetsResponseIterator(final ListEdgeSubnetsRequest request) {
        return new ResponseIterable<ListEdgeSubnetsRequest.Builder, ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>(new Supplier<ListEdgeSubnetsRequest.Builder>(){

            public ListEdgeSubnetsRequest.Builder get() {
                return ListEdgeSubnetsRequest.builder().copy(request);
            }
        }, new Function<ListEdgeSubnetsResponse, String>(){

            public String apply(ListEdgeSubnetsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListEdgeSubnetsRequest.Builder>, ListEdgeSubnetsRequest>(){

            public ListEdgeSubnetsRequest apply(RequestBuilderAndToken<ListEdgeSubnetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>(){

            public ListEdgeSubnetsResponse apply(ListEdgeSubnetsRequest request) {
                return WaasPaginators.this.client.listEdgeSubnets(request);
            }
        });
    }

    public Iterable<EdgeSubnet> listEdgeSubnetsRecordIterator(final ListEdgeSubnetsRequest request) {
        return new ResponseRecordIterable<ListEdgeSubnetsRequest.Builder, ListEdgeSubnetsRequest, ListEdgeSubnetsResponse, EdgeSubnet>(new Supplier<ListEdgeSubnetsRequest.Builder>(){

            public ListEdgeSubnetsRequest.Builder get() {
                return ListEdgeSubnetsRequest.builder().copy(request);
            }
        }, new Function<ListEdgeSubnetsResponse, String>(){

            public String apply(ListEdgeSubnetsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListEdgeSubnetsRequest.Builder>, ListEdgeSubnetsRequest>(){

            public ListEdgeSubnetsRequest apply(RequestBuilderAndToken<ListEdgeSubnetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>(){

            public ListEdgeSubnetsResponse apply(ListEdgeSubnetsRequest request) {
                return WaasPaginators.this.client.listEdgeSubnets(request);
            }
        }, new Function<ListEdgeSubnetsResponse, List<EdgeSubnet>>(){

            public List<EdgeSubnet> apply(ListEdgeSubnetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListGoodBotsResponse> listGoodBotsResponseIterator(final ListGoodBotsRequest request) {
        return new ResponseIterable<ListGoodBotsRequest.Builder, ListGoodBotsRequest, ListGoodBotsResponse>(new Supplier<ListGoodBotsRequest.Builder>(){

            public ListGoodBotsRequest.Builder get() {
                return ListGoodBotsRequest.builder().copy(request);
            }
        }, new Function<ListGoodBotsResponse, String>(){

            public String apply(ListGoodBotsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListGoodBotsRequest.Builder>, ListGoodBotsRequest>(){

            public ListGoodBotsRequest apply(RequestBuilderAndToken<ListGoodBotsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListGoodBotsRequest, ListGoodBotsResponse>(){

            public ListGoodBotsResponse apply(ListGoodBotsRequest request) {
                return WaasPaginators.this.client.listGoodBots(request);
            }
        });
    }

    public Iterable<GoodBot> listGoodBotsRecordIterator(final ListGoodBotsRequest request) {
        return new ResponseRecordIterable<ListGoodBotsRequest.Builder, ListGoodBotsRequest, ListGoodBotsResponse, GoodBot>(new Supplier<ListGoodBotsRequest.Builder>(){

            public ListGoodBotsRequest.Builder get() {
                return ListGoodBotsRequest.builder().copy(request);
            }
        }, new Function<ListGoodBotsResponse, String>(){

            public String apply(ListGoodBotsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListGoodBotsRequest.Builder>, ListGoodBotsRequest>(){

            public ListGoodBotsRequest apply(RequestBuilderAndToken<ListGoodBotsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListGoodBotsRequest, ListGoodBotsResponse>(){

            public ListGoodBotsResponse apply(ListGoodBotsRequest request) {
                return WaasPaginators.this.client.listGoodBots(request);
            }
        }, new Function<ListGoodBotsResponse, List<GoodBot>>(){

            public List<GoodBot> apply(ListGoodBotsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListProtectionRulesResponse> listProtectionRulesResponseIterator(final ListProtectionRulesRequest request) {
        return new ResponseIterable<ListProtectionRulesRequest.Builder, ListProtectionRulesRequest, ListProtectionRulesResponse>(new Supplier<ListProtectionRulesRequest.Builder>(){

            public ListProtectionRulesRequest.Builder get() {
                return ListProtectionRulesRequest.builder().copy(request);
            }
        }, new Function<ListProtectionRulesResponse, String>(){

            public String apply(ListProtectionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListProtectionRulesRequest.Builder>, ListProtectionRulesRequest>(){

            public ListProtectionRulesRequest apply(RequestBuilderAndToken<ListProtectionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListProtectionRulesRequest, ListProtectionRulesResponse>(){

            public ListProtectionRulesResponse apply(ListProtectionRulesRequest request) {
                return WaasPaginators.this.client.listProtectionRules(request);
            }
        });
    }

    public Iterable<ProtectionRule> listProtectionRulesRecordIterator(final ListProtectionRulesRequest request) {
        return new ResponseRecordIterable<ListProtectionRulesRequest.Builder, ListProtectionRulesRequest, ListProtectionRulesResponse, ProtectionRule>(new Supplier<ListProtectionRulesRequest.Builder>(){

            public ListProtectionRulesRequest.Builder get() {
                return ListProtectionRulesRequest.builder().copy(request);
            }
        }, new Function<ListProtectionRulesResponse, String>(){

            public String apply(ListProtectionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListProtectionRulesRequest.Builder>, ListProtectionRulesRequest>(){

            public ListProtectionRulesRequest apply(RequestBuilderAndToken<ListProtectionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListProtectionRulesRequest, ListProtectionRulesResponse>(){

            public ListProtectionRulesResponse apply(ListProtectionRulesRequest request) {
                return WaasPaginators.this.client.listProtectionRules(request);
            }
        }, new Function<ListProtectionRulesResponse, List<ProtectionRule>>(){

            public List<ProtectionRule> apply(ListProtectionRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRecommendationsResponse> listRecommendationsResponseIterator(final ListRecommendationsRequest request) {
        return new ResponseIterable<ListRecommendationsRequest.Builder, ListRecommendationsRequest, ListRecommendationsResponse>(new Supplier<ListRecommendationsRequest.Builder>(){

            public ListRecommendationsRequest.Builder get() {
                return ListRecommendationsRequest.builder().copy(request);
            }
        }, new Function<ListRecommendationsResponse, String>(){

            public String apply(ListRecommendationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRecommendationsRequest.Builder>, ListRecommendationsRequest>(){

            public ListRecommendationsRequest apply(RequestBuilderAndToken<ListRecommendationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRecommendationsRequest, ListRecommendationsResponse>(){

            public ListRecommendationsResponse apply(ListRecommendationsRequest request) {
                return WaasPaginators.this.client.listRecommendations(request);
            }
        });
    }

    public Iterable<Recommendation> listRecommendationsRecordIterator(final ListRecommendationsRequest request) {
        return new ResponseRecordIterable<ListRecommendationsRequest.Builder, ListRecommendationsRequest, ListRecommendationsResponse, Recommendation>(new Supplier<ListRecommendationsRequest.Builder>(){

            public ListRecommendationsRequest.Builder get() {
                return ListRecommendationsRequest.builder().copy(request);
            }
        }, new Function<ListRecommendationsResponse, String>(){

            public String apply(ListRecommendationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRecommendationsRequest.Builder>, ListRecommendationsRequest>(){

            public ListRecommendationsRequest apply(RequestBuilderAndToken<ListRecommendationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRecommendationsRequest, ListRecommendationsResponse>(){

            public ListRecommendationsResponse apply(ListRecommendationsRequest request) {
                return WaasPaginators.this.client.listRecommendations(request);
            }
        }, new Function<ListRecommendationsResponse, List<Recommendation>>(){

            public List<Recommendation> apply(ListRecommendationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListThreatFeedsResponse> listThreatFeedsResponseIterator(final ListThreatFeedsRequest request) {
        return new ResponseIterable<ListThreatFeedsRequest.Builder, ListThreatFeedsRequest, ListThreatFeedsResponse>(new Supplier<ListThreatFeedsRequest.Builder>(){

            public ListThreatFeedsRequest.Builder get() {
                return ListThreatFeedsRequest.builder().copy(request);
            }
        }, new Function<ListThreatFeedsResponse, String>(){

            public String apply(ListThreatFeedsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListThreatFeedsRequest.Builder>, ListThreatFeedsRequest>(){

            public ListThreatFeedsRequest apply(RequestBuilderAndToken<ListThreatFeedsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListThreatFeedsRequest, ListThreatFeedsResponse>(){

            public ListThreatFeedsResponse apply(ListThreatFeedsRequest request) {
                return WaasPaginators.this.client.listThreatFeeds(request);
            }
        });
    }

    public Iterable<ThreatFeed> listThreatFeedsRecordIterator(final ListThreatFeedsRequest request) {
        return new ResponseRecordIterable<ListThreatFeedsRequest.Builder, ListThreatFeedsRequest, ListThreatFeedsResponse, ThreatFeed>(new Supplier<ListThreatFeedsRequest.Builder>(){

            public ListThreatFeedsRequest.Builder get() {
                return ListThreatFeedsRequest.builder().copy(request);
            }
        }, new Function<ListThreatFeedsResponse, String>(){

            public String apply(ListThreatFeedsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListThreatFeedsRequest.Builder>, ListThreatFeedsRequest>(){

            public ListThreatFeedsRequest apply(RequestBuilderAndToken<ListThreatFeedsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListThreatFeedsRequest, ListThreatFeedsResponse>(){

            public ListThreatFeedsResponse apply(ListThreatFeedsRequest request) {
                return WaasPaginators.this.client.listThreatFeeds(request);
            }
        }, new Function<ListThreatFeedsResponse, List<ThreatFeed>>(){

            public List<ThreatFeed> apply(ListThreatFeedsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWaasPoliciesResponse> listWaasPoliciesResponseIterator(final ListWaasPoliciesRequest request) {
        return new ResponseIterable<ListWaasPoliciesRequest.Builder, ListWaasPoliciesRequest, ListWaasPoliciesResponse>(new Supplier<ListWaasPoliciesRequest.Builder>(){

            public ListWaasPoliciesRequest.Builder get() {
                return ListWaasPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListWaasPoliciesResponse, String>(){

            public String apply(ListWaasPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWaasPoliciesRequest.Builder>, ListWaasPoliciesRequest>(){

            public ListWaasPoliciesRequest apply(RequestBuilderAndToken<ListWaasPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWaasPoliciesRequest, ListWaasPoliciesResponse>(){

            public ListWaasPoliciesResponse apply(ListWaasPoliciesRequest request) {
                return WaasPaginators.this.client.listWaasPolicies(request);
            }
        });
    }

    public Iterable<WaasPolicySummary> listWaasPoliciesRecordIterator(final ListWaasPoliciesRequest request) {
        return new ResponseRecordIterable<ListWaasPoliciesRequest.Builder, ListWaasPoliciesRequest, ListWaasPoliciesResponse, WaasPolicySummary>(new Supplier<ListWaasPoliciesRequest.Builder>(){

            public ListWaasPoliciesRequest.Builder get() {
                return ListWaasPoliciesRequest.builder().copy(request);
            }
        }, new Function<ListWaasPoliciesResponse, String>(){

            public String apply(ListWaasPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWaasPoliciesRequest.Builder>, ListWaasPoliciesRequest>(){

            public ListWaasPoliciesRequest apply(RequestBuilderAndToken<ListWaasPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWaasPoliciesRequest, ListWaasPoliciesResponse>(){

            public ListWaasPoliciesResponse apply(ListWaasPoliciesRequest request) {
                return WaasPaginators.this.client.listWaasPolicies(request);
            }
        }, new Function<ListWaasPoliciesResponse, List<WaasPolicySummary>>(){

            public List<WaasPolicySummary> apply(ListWaasPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWaasPolicyCustomProtectionRulesResponse> listWaasPolicyCustomProtectionRulesResponseIterator(final ListWaasPolicyCustomProtectionRulesRequest request) {
        return new ResponseIterable<ListWaasPolicyCustomProtectionRulesRequest.Builder, ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>(new Supplier<ListWaasPolicyCustomProtectionRulesRequest.Builder>(){

            public ListWaasPolicyCustomProtectionRulesRequest.Builder get() {
                return ListWaasPolicyCustomProtectionRulesRequest.builder().copy(request);
            }
        }, new Function<ListWaasPolicyCustomProtectionRulesResponse, String>(){

            public String apply(ListWaasPolicyCustomProtectionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWaasPolicyCustomProtectionRulesRequest.Builder>, ListWaasPolicyCustomProtectionRulesRequest>(){

            public ListWaasPolicyCustomProtectionRulesRequest apply(RequestBuilderAndToken<ListWaasPolicyCustomProtectionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>(){

            public ListWaasPolicyCustomProtectionRulesResponse apply(ListWaasPolicyCustomProtectionRulesRequest request) {
                return WaasPaginators.this.client.listWaasPolicyCustomProtectionRules(request);
            }
        });
    }

    public Iterable<WaasPolicyCustomProtectionRuleSummary> listWaasPolicyCustomProtectionRulesRecordIterator(final ListWaasPolicyCustomProtectionRulesRequest request) {
        return new ResponseRecordIterable<ListWaasPolicyCustomProtectionRulesRequest.Builder, ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse, WaasPolicyCustomProtectionRuleSummary>(new Supplier<ListWaasPolicyCustomProtectionRulesRequest.Builder>(){

            public ListWaasPolicyCustomProtectionRulesRequest.Builder get() {
                return ListWaasPolicyCustomProtectionRulesRequest.builder().copy(request);
            }
        }, new Function<ListWaasPolicyCustomProtectionRulesResponse, String>(){

            public String apply(ListWaasPolicyCustomProtectionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWaasPolicyCustomProtectionRulesRequest.Builder>, ListWaasPolicyCustomProtectionRulesRequest>(){

            public ListWaasPolicyCustomProtectionRulesRequest apply(RequestBuilderAndToken<ListWaasPolicyCustomProtectionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>(){

            public ListWaasPolicyCustomProtectionRulesResponse apply(ListWaasPolicyCustomProtectionRulesRequest request) {
                return WaasPaginators.this.client.listWaasPolicyCustomProtectionRules(request);
            }
        }, new Function<ListWaasPolicyCustomProtectionRulesResponse, List<WaasPolicyCustomProtectionRuleSummary>>(){

            public List<WaasPolicyCustomProtectionRuleSummary> apply(ListWaasPolicyCustomProtectionRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWafBlockedRequestsResponse> listWafBlockedRequestsResponseIterator(final ListWafBlockedRequestsRequest request) {
        return new ResponseIterable<ListWafBlockedRequestsRequest.Builder, ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>(new Supplier<ListWafBlockedRequestsRequest.Builder>(){

            public ListWafBlockedRequestsRequest.Builder get() {
                return ListWafBlockedRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWafBlockedRequestsResponse, String>(){

            public String apply(ListWafBlockedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafBlockedRequestsRequest.Builder>, ListWafBlockedRequestsRequest>(){

            public ListWafBlockedRequestsRequest apply(RequestBuilderAndToken<ListWafBlockedRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>(){

            public ListWafBlockedRequestsResponse apply(ListWafBlockedRequestsRequest request) {
                return WaasPaginators.this.client.listWafBlockedRequests(request);
            }
        });
    }

    public Iterable<WafBlockedRequest> listWafBlockedRequestsRecordIterator(final ListWafBlockedRequestsRequest request) {
        return new ResponseRecordIterable<ListWafBlockedRequestsRequest.Builder, ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse, WafBlockedRequest>(new Supplier<ListWafBlockedRequestsRequest.Builder>(){

            public ListWafBlockedRequestsRequest.Builder get() {
                return ListWafBlockedRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWafBlockedRequestsResponse, String>(){

            public String apply(ListWafBlockedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafBlockedRequestsRequest.Builder>, ListWafBlockedRequestsRequest>(){

            public ListWafBlockedRequestsRequest apply(RequestBuilderAndToken<ListWafBlockedRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>(){

            public ListWafBlockedRequestsResponse apply(ListWafBlockedRequestsRequest request) {
                return WaasPaginators.this.client.listWafBlockedRequests(request);
            }
        }, new Function<ListWafBlockedRequestsResponse, List<WafBlockedRequest>>(){

            public List<WafBlockedRequest> apply(ListWafBlockedRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWafLogsResponse> listWafLogsResponseIterator(final ListWafLogsRequest request) {
        return new ResponseIterable<ListWafLogsRequest.Builder, ListWafLogsRequest, ListWafLogsResponse>(new Supplier<ListWafLogsRequest.Builder>(){

            public ListWafLogsRequest.Builder get() {
                return ListWafLogsRequest.builder().copy(request);
            }
        }, new Function<ListWafLogsResponse, String>(){

            public String apply(ListWafLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafLogsRequest.Builder>, ListWafLogsRequest>(){

            public ListWafLogsRequest apply(RequestBuilderAndToken<ListWafLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafLogsRequest, ListWafLogsResponse>(){

            public ListWafLogsResponse apply(ListWafLogsRequest request) {
                return WaasPaginators.this.client.listWafLogs(request);
            }
        });
    }

    public Iterable<WafLog> listWafLogsRecordIterator(final ListWafLogsRequest request) {
        return new ResponseRecordIterable<ListWafLogsRequest.Builder, ListWafLogsRequest, ListWafLogsResponse, WafLog>(new Supplier<ListWafLogsRequest.Builder>(){

            public ListWafLogsRequest.Builder get() {
                return ListWafLogsRequest.builder().copy(request);
            }
        }, new Function<ListWafLogsResponse, String>(){

            public String apply(ListWafLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafLogsRequest.Builder>, ListWafLogsRequest>(){

            public ListWafLogsRequest apply(RequestBuilderAndToken<ListWafLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafLogsRequest, ListWafLogsResponse>(){

            public ListWafLogsResponse apply(ListWafLogsRequest request) {
                return WaasPaginators.this.client.listWafLogs(request);
            }
        }, new Function<ListWafLogsResponse, List<WafLog>>(){

            public List<WafLog> apply(ListWafLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWafRequestsResponse> listWafRequestsResponseIterator(final ListWafRequestsRequest request) {
        return new ResponseIterable<ListWafRequestsRequest.Builder, ListWafRequestsRequest, ListWafRequestsResponse>(new Supplier<ListWafRequestsRequest.Builder>(){

            public ListWafRequestsRequest.Builder get() {
                return ListWafRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWafRequestsResponse, String>(){

            public String apply(ListWafRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafRequestsRequest.Builder>, ListWafRequestsRequest>(){

            public ListWafRequestsRequest apply(RequestBuilderAndToken<ListWafRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafRequestsRequest, ListWafRequestsResponse>(){

            public ListWafRequestsResponse apply(ListWafRequestsRequest request) {
                return WaasPaginators.this.client.listWafRequests(request);
            }
        });
    }

    public Iterable<WafRequest> listWafRequestsRecordIterator(final ListWafRequestsRequest request) {
        return new ResponseRecordIterable<ListWafRequestsRequest.Builder, ListWafRequestsRequest, ListWafRequestsResponse, WafRequest>(new Supplier<ListWafRequestsRequest.Builder>(){

            public ListWafRequestsRequest.Builder get() {
                return ListWafRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWafRequestsResponse, String>(){

            public String apply(ListWafRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafRequestsRequest.Builder>, ListWafRequestsRequest>(){

            public ListWafRequestsRequest apply(RequestBuilderAndToken<ListWafRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafRequestsRequest, ListWafRequestsResponse>(){

            public ListWafRequestsResponse apply(ListWafRequestsRequest request) {
                return WaasPaginators.this.client.listWafRequests(request);
            }
        }, new Function<ListWafRequestsResponse, List<WafRequest>>(){

            public List<WafRequest> apply(ListWafRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWafTrafficResponse> listWafTrafficResponseIterator(final ListWafTrafficRequest request) {
        return new ResponseIterable<ListWafTrafficRequest.Builder, ListWafTrafficRequest, ListWafTrafficResponse>(new Supplier<ListWafTrafficRequest.Builder>(){

            public ListWafTrafficRequest.Builder get() {
                return ListWafTrafficRequest.builder().copy(request);
            }
        }, new Function<ListWafTrafficResponse, String>(){

            public String apply(ListWafTrafficResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafTrafficRequest.Builder>, ListWafTrafficRequest>(){

            public ListWafTrafficRequest apply(RequestBuilderAndToken<ListWafTrafficRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafTrafficRequest, ListWafTrafficResponse>(){

            public ListWafTrafficResponse apply(ListWafTrafficRequest request) {
                return WaasPaginators.this.client.listWafTraffic(request);
            }
        });
    }

    public Iterable<WafTrafficDatum> listWafTrafficRecordIterator(final ListWafTrafficRequest request) {
        return new ResponseRecordIterable<ListWafTrafficRequest.Builder, ListWafTrafficRequest, ListWafTrafficResponse, WafTrafficDatum>(new Supplier<ListWafTrafficRequest.Builder>(){

            public ListWafTrafficRequest.Builder get() {
                return ListWafTrafficRequest.builder().copy(request);
            }
        }, new Function<ListWafTrafficResponse, String>(){

            public String apply(ListWafTrafficResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWafTrafficRequest.Builder>, ListWafTrafficRequest>(){

            public ListWafTrafficRequest apply(RequestBuilderAndToken<ListWafTrafficRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWafTrafficRequest, ListWafTrafficResponse>(){

            public ListWafTrafficResponse apply(ListWafTrafficRequest request) {
                return WaasPaginators.this.client.listWafTraffic(request);
            }
        }, new Function<ListWafTrafficResponse, List<WafTrafficDatum>>(){

            public List<WafTrafficDatum> apply(ListWafTrafficResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWhitelistsResponse> listWhitelistsResponseIterator(final ListWhitelistsRequest request) {
        return new ResponseIterable<ListWhitelistsRequest.Builder, ListWhitelistsRequest, ListWhitelistsResponse>(new Supplier<ListWhitelistsRequest.Builder>(){

            public ListWhitelistsRequest.Builder get() {
                return ListWhitelistsRequest.builder().copy(request);
            }
        }, new Function<ListWhitelistsResponse, String>(){

            public String apply(ListWhitelistsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWhitelistsRequest.Builder>, ListWhitelistsRequest>(){

            public ListWhitelistsRequest apply(RequestBuilderAndToken<ListWhitelistsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWhitelistsRequest, ListWhitelistsResponse>(){

            public ListWhitelistsResponse apply(ListWhitelistsRequest request) {
                return WaasPaginators.this.client.listWhitelists(request);
            }
        });
    }

    public Iterable<Whitelist> listWhitelistsRecordIterator(final ListWhitelistsRequest request) {
        return new ResponseRecordIterable<ListWhitelistsRequest.Builder, ListWhitelistsRequest, ListWhitelistsResponse, Whitelist>(new Supplier<ListWhitelistsRequest.Builder>(){

            public ListWhitelistsRequest.Builder get() {
                return ListWhitelistsRequest.builder().copy(request);
            }
        }, new Function<ListWhitelistsResponse, String>(){

            public String apply(ListWhitelistsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWhitelistsRequest.Builder>, ListWhitelistsRequest>(){

            public ListWhitelistsRequest apply(RequestBuilderAndToken<ListWhitelistsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWhitelistsRequest, ListWhitelistsResponse>(){

            public ListWhitelistsResponse apply(ListWhitelistsRequest request) {
                return WaasPaginators.this.client.listWhitelists(request);
            }
        }, new Function<ListWhitelistsResponse, List<Whitelist>>(){

            public List<Whitelist> apply(ListWhitelistsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return WaasPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequestSummary>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return WaasPaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public WaasPaginators(Waas client) {
        this.client = client;
    }
}

