/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.waas.responses.ChangeCertificateCompartmentResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeCertificateCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeCertificateCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeCertificateCompartmentRequest interceptRequest(ChangeCertificateCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeCertificateCompartmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeCertificateCompartmentDetails(), (String)"changeCertificateCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("certificates").path(HttpUtils.encodePathSegment(request.getCertificateId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeCertificateCompartmentResponse> fromResponse() {
        Function<Response, ChangeCertificateCompartmentResponse> transformer = new Function<Response, ChangeCertificateCompartmentResponse>(){

            public ChangeCertificateCompartmentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ChangeCertificateCompartmentResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ChangeCertificateCompartmentResponse.Builder builder = ChangeCertificateCompartmentResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ChangeCertificateCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

