/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.requests.ChangeWaasPolicyCompartmentRequest;
import com.oracle.bmc.waas.responses.ChangeWaasPolicyCompartmentResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeWaasPolicyCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeWaasPolicyCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeWaasPolicyCompartmentRequest interceptRequest(ChangeWaasPolicyCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeWaasPolicyCompartmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeWaasPolicyCompartmentDetails(), (String)"changeWaasPolicyCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("waasPolicies").path(HttpUtils.encodePathSegment(request.getWaasPolicyId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeWaasPolicyCompartmentResponse> fromResponse() {
        Function<Response, ChangeWaasPolicyCompartmentResponse> transformer = new Function<Response, ChangeWaasPolicyCompartmentResponse>(){

            public ChangeWaasPolicyCompartmentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ChangeWaasPolicyCompartmentResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ChangeWaasPolicyCompartmentResponse.Builder builder = ChangeWaasPolicyCompartmentResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ChangeWaasPolicyCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

