/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.model.HumanInteractionChallenge;
import com.oracle.bmc.waas.requests.GetHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.responses.GetHumanInteractionChallengeResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetHumanInteractionChallengeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetHumanInteractionChallengeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetHumanInteractionChallengeRequest interceptRequest(GetHumanInteractionChallengeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetHumanInteractionChallengeRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("waasPolicies").path(HttpUtils.encodePathSegment(request.getWaasPolicyId())).path("wafConfig").path("humanInteractionChallenge");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetHumanInteractionChallengeResponse> fromResponse() {
        Function<Response, GetHumanInteractionChallengeResponse> transformer = new Function<Response, GetHumanInteractionChallengeResponse>(){

            public GetHumanInteractionChallengeResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetHumanInteractionChallengeResponse");
                Function<Response, WithHeaders<HumanInteractionChallenge>> responseFn = RESPONSE_CONVERSION_FACTORY.create(HumanInteractionChallenge.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetHumanInteractionChallengeResponse.Builder builder = GetHumanInteractionChallengeResponse.builder();
                builder.humanInteractionChallenge((HumanInteractionChallenge)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetHumanInteractionChallengeResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

