/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.model.Captcha;
import com.oracle.bmc.waas.requests.ListCaptchasRequest;
import com.oracle.bmc.waas.responses.ListCaptchasResponse;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCaptchasConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListCaptchasConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListCaptchasRequest interceptRequest(ListCaptchasRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListCaptchasRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("waasPolicies").path(HttpUtils.encodePathSegment(request.getWaasPolicyId())).path("wafConfig").path("captchas");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListCaptchasResponse> fromResponse() {
        Function<Response, ListCaptchasResponse> transformer = new Function<Response, ListCaptchasResponse>(){

            public ListCaptchasResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListCaptchasResponse");
                Function<Response, WithHeaders<List<Captcha>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<Captcha>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListCaptchasResponse.Builder builder = ListCaptchasResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListCaptchasResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

