/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.model.CustomProtectionRuleSummary;
import com.oracle.bmc.waas.requests.ListCustomProtectionRulesRequest;
import com.oracle.bmc.waas.responses.ListCustomProtectionRulesResponse;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCustomProtectionRulesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListCustomProtectionRulesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListCustomProtectionRulesRequest interceptRequest(ListCustomProtectionRulesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListCustomProtectionRulesRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("customProtectionRules");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        if (request.getId() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "id", request.getId(), CollectionFormatType.Multi);
        }
        if (request.getDisplayName() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "displayName", request.getDisplayName(), CollectionFormatType.Multi);
        }
        if (request.getLifecycleState() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi);
        }
        if (request.getTimeCreatedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedGreaterThanOrEqualTo()));
        }
        if (request.getTimeCreatedLessThan() != null) {
            target = target.queryParam("timeCreatedLessThan", HttpUtils.attemptEncodeQueryParam(request.getTimeCreatedLessThan()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListCustomProtectionRulesResponse> fromResponse() {
        Function<Response, ListCustomProtectionRulesResponse> transformer = new Function<Response, ListCustomProtectionRulesResponse>(){

            public ListCustomProtectionRulesResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListCustomProtectionRulesResponse");
                Function<Response, WithHeaders<List<CustomProtectionRuleSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<CustomProtectionRuleSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListCustomProtectionRulesResponse.Builder builder = ListCustomProtectionRulesResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListCustomProtectionRulesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

