/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.model.WafLog;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWafLogsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListWafLogsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListWafLogsRequest interceptRequest(ListWafLogsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListWafLogsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("waasPolicies").path(HttpUtils.encodePathSegment(request.getWaasPolicyId())).path("wafLogs");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getTimeObservedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeObservedGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimeObservedGreaterThanOrEqualTo()));
        }
        if (request.getTimeObservedLessThan() != null) {
            target = target.queryParam("timeObservedLessThan", HttpUtils.attemptEncodeQueryParam(request.getTimeObservedLessThan()));
        }
        if (request.getTextContains() != null) {
            target = target.queryParam("textContains", HttpUtils.attemptEncodeQueryParam(request.getTextContains()));
        }
        if (request.getAccessRuleKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "accessRuleKey", request.getAccessRuleKey(), CollectionFormatType.Multi);
        }
        if (request.getAction() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "action", request.getAction(), CollectionFormatType.Multi);
        }
        if (request.getClientAddress() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "clientAddress", request.getClientAddress(), CollectionFormatType.Multi);
        }
        if (request.getCountryCode() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "countryCode", request.getCountryCode(), CollectionFormatType.Multi);
        }
        if (request.getCountryName() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "countryName", request.getCountryName(), CollectionFormatType.Multi);
        }
        if (request.getFingerprint() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "fingerprint", request.getFingerprint(), CollectionFormatType.Multi);
        }
        if (request.getHttpMethod() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "httpMethod", request.getHttpMethod(), CollectionFormatType.Multi);
        }
        if (request.getIncidentKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "incidentKey", request.getIncidentKey(), CollectionFormatType.Multi);
        }
        if (request.getLogType() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "logType", request.getLogType(), CollectionFormatType.Multi);
        }
        if (request.getOriginAddress() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "originAddress", request.getOriginAddress(), CollectionFormatType.Multi);
        }
        if (request.getReferrer() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "referrer", request.getReferrer(), CollectionFormatType.Multi);
        }
        if (request.getRequestUrl() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "requestUrl", request.getRequestUrl(), CollectionFormatType.Multi);
        }
        if (request.getResponseCode() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "responseCode", request.getResponseCode(), CollectionFormatType.Multi);
        }
        if (request.getThreatFeedKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "threatFeedKey", request.getThreatFeedKey(), CollectionFormatType.Multi);
        }
        if (request.getUserAgent() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "userAgent", request.getUserAgent(), CollectionFormatType.Multi);
        }
        if (request.getProtectionRuleKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam(target, "protectionRuleKey", request.getProtectionRuleKey(), CollectionFormatType.Multi);
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListWafLogsResponse> fromResponse() {
        Function<Response, ListWafLogsResponse> transformer = new Function<Response, ListWafLogsResponse>(){

            public ListWafLogsResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for ListWafLogsResponse");
                Function<Response, WithHeaders<List<WafLog>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<WafLog>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListWafLogsResponse.Builder builder = ListWafLogsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                ListWafLogsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

