/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class AcceptRecommendationsRequest
extends BmcRequest {
    private String waasPolicyId;
    private List<String> protectionRuleKeys;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"waasPolicyId", "protectionRuleKeys", "opcRequestId", "ifMatch"})
    AcceptRecommendationsRequest(String waasPolicyId, List<String> protectionRuleKeys, String opcRequestId, String ifMatch) {
        this.waasPolicyId = waasPolicyId;
        this.protectionRuleKeys = protectionRuleKeys;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<String> getProtectionRuleKeys() {
        return this.protectionRuleKeys;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String waasPolicyId;
        private List<String> protectionRuleKeys;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AcceptRecommendationsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.protectionRuleKeys(o.getProtectionRuleKeys());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AcceptRecommendationsRequest build() {
            AcceptRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder protectionRuleKeys(List<String> protectionRuleKeys) {
            this.protectionRuleKeys = protectionRuleKeys;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public AcceptRecommendationsRequest buildWithoutInvocationCallback() {
            return new AcceptRecommendationsRequest(this.waasPolicyId, this.protectionRuleKeys, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "AcceptRecommendationsRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", protectionRuleKeys=" + this.protectionRuleKeys + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

