/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAddressListRequest
extends BmcRequest {
    private String addressListId;
    private String opcRequestId;

    @ConstructorProperties(value={"addressListId", "opcRequestId"})
    GetAddressListRequest(String addressListId, String opcRequestId) {
        this.addressListId = addressListId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAddressListId() {
        return this.addressListId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String addressListId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAddressListRequest o) {
            this.addressListId(o.getAddressListId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAddressListRequest build() {
            GetAddressListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAddressListRequest buildWithoutInvocationCallback() {
            return new GetAddressListRequest(this.addressListId, this.opcRequestId);
        }

        public String toString() {
            return "GetAddressListRequest.Builder(addressListId=" + this.addressListId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

