/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListWafLogsRequest
extends BmcRequest {
    private String waasPolicyId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private Date timeObservedGreaterThanOrEqualTo;
    private Date timeObservedLessThan;
    private String textContains;
    private List<String> accessRuleKey;
    private List<Action> action;
    private List<String> clientAddress;
    private List<String> countryCode;
    private List<String> countryName;
    private List<String> fingerprint;
    private List<HttpMethod> httpMethod;
    private List<String> incidentKey;
    private List<LogType> logType;
    private List<String> originAddress;
    private List<String> referrer;
    private List<String> requestUrl;
    private List<Integer> responseCode;
    private List<String> threatFeedKey;
    private List<String> userAgent;
    private List<String> protectionRuleKey;

    @ConstructorProperties(value={"waasPolicyId", "opcRequestId", "limit", "page", "timeObservedGreaterThanOrEqualTo", "timeObservedLessThan", "textContains", "accessRuleKey", "action", "clientAddress", "countryCode", "countryName", "fingerprint", "httpMethod", "incidentKey", "logType", "originAddress", "referrer", "requestUrl", "responseCode", "threatFeedKey", "userAgent", "protectionRuleKey"})
    ListWafLogsRequest(String waasPolicyId, String opcRequestId, Integer limit, String page, Date timeObservedGreaterThanOrEqualTo, Date timeObservedLessThan, String textContains, List<String> accessRuleKey, List<Action> action, List<String> clientAddress, List<String> countryCode, List<String> countryName, List<String> fingerprint, List<HttpMethod> httpMethod, List<String> incidentKey, List<LogType> logType, List<String> originAddress, List<String> referrer, List<String> requestUrl, List<Integer> responseCode, List<String> threatFeedKey, List<String> userAgent, List<String> protectionRuleKey) {
        this.waasPolicyId = waasPolicyId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.timeObservedGreaterThanOrEqualTo = timeObservedGreaterThanOrEqualTo;
        this.timeObservedLessThan = timeObservedLessThan;
        this.textContains = textContains;
        this.accessRuleKey = accessRuleKey;
        this.action = action;
        this.clientAddress = clientAddress;
        this.countryCode = countryCode;
        this.countryName = countryName;
        this.fingerprint = fingerprint;
        this.httpMethod = httpMethod;
        this.incidentKey = incidentKey;
        this.logType = logType;
        this.originAddress = originAddress;
        this.referrer = referrer;
        this.requestUrl = requestUrl;
        this.responseCode = responseCode;
        this.threatFeedKey = threatFeedKey;
        this.userAgent = userAgent;
        this.protectionRuleKey = protectionRuleKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Date getTimeObservedGreaterThanOrEqualTo() {
        return this.timeObservedGreaterThanOrEqualTo;
    }

    public Date getTimeObservedLessThan() {
        return this.timeObservedLessThan;
    }

    public String getTextContains() {
        return this.textContains;
    }

    public List<String> getAccessRuleKey() {
        return this.accessRuleKey;
    }

    public List<Action> getAction() {
        return this.action;
    }

    public List<String> getClientAddress() {
        return this.clientAddress;
    }

    public List<String> getCountryCode() {
        return this.countryCode;
    }

    public List<String> getCountryName() {
        return this.countryName;
    }

    public List<String> getFingerprint() {
        return this.fingerprint;
    }

    public List<HttpMethod> getHttpMethod() {
        return this.httpMethod;
    }

    public List<String> getIncidentKey() {
        return this.incidentKey;
    }

    public List<LogType> getLogType() {
        return this.logType;
    }

    public List<String> getOriginAddress() {
        return this.originAddress;
    }

    public List<String> getReferrer() {
        return this.referrer;
    }

    public List<String> getRequestUrl() {
        return this.requestUrl;
    }

    public List<Integer> getResponseCode() {
        return this.responseCode;
    }

    public List<String> getThreatFeedKey() {
        return this.threatFeedKey;
    }

    public List<String> getUserAgent() {
        return this.userAgent;
    }

    public List<String> getProtectionRuleKey() {
        return this.protectionRuleKey;
    }

    public static class Builder {
        private String waasPolicyId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private Date timeObservedGreaterThanOrEqualTo;
        private Date timeObservedLessThan;
        private String textContains;
        private List<String> accessRuleKey;
        private List<Action> action;
        private List<String> clientAddress;
        private List<String> countryCode;
        private List<String> countryName;
        private List<String> fingerprint;
        private List<HttpMethod> httpMethod;
        private List<String> incidentKey;
        private List<LogType> logType;
        private List<String> originAddress;
        private List<String> referrer;
        private List<String> requestUrl;
        private List<Integer> responseCode;
        private List<String> threatFeedKey;
        private List<String> userAgent;
        private List<String> protectionRuleKey;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWafLogsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.timeObservedGreaterThanOrEqualTo(o.getTimeObservedGreaterThanOrEqualTo());
            this.timeObservedLessThan(o.getTimeObservedLessThan());
            this.textContains(o.getTextContains());
            this.accessRuleKey(o.getAccessRuleKey());
            this.action(o.getAction());
            this.clientAddress(o.getClientAddress());
            this.countryCode(o.getCountryCode());
            this.countryName(o.getCountryName());
            this.fingerprint(o.getFingerprint());
            this.httpMethod(o.getHttpMethod());
            this.incidentKey(o.getIncidentKey());
            this.logType(o.getLogType());
            this.originAddress(o.getOriginAddress());
            this.referrer(o.getReferrer());
            this.requestUrl(o.getRequestUrl());
            this.responseCode(o.getResponseCode());
            this.threatFeedKey(o.getThreatFeedKey());
            this.userAgent(o.getUserAgent());
            this.protectionRuleKey(o.getProtectionRuleKey());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWafLogsRequest build() {
            ListWafLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder timeObservedGreaterThanOrEqualTo(Date timeObservedGreaterThanOrEqualTo) {
            this.timeObservedGreaterThanOrEqualTo = timeObservedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeObservedLessThan(Date timeObservedLessThan) {
            this.timeObservedLessThan = timeObservedLessThan;
            return this;
        }

        public Builder textContains(String textContains) {
            this.textContains = textContains;
            return this;
        }

        public Builder accessRuleKey(List<String> accessRuleKey) {
            this.accessRuleKey = accessRuleKey;
            return this;
        }

        public Builder action(List<Action> action) {
            this.action = action;
            return this;
        }

        public Builder clientAddress(List<String> clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }

        public Builder countryCode(List<String> countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder countryName(List<String> countryName) {
            this.countryName = countryName;
            return this;
        }

        public Builder fingerprint(List<String> fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder httpMethod(List<HttpMethod> httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder incidentKey(List<String> incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public Builder logType(List<LogType> logType) {
            this.logType = logType;
            return this;
        }

        public Builder originAddress(List<String> originAddress) {
            this.originAddress = originAddress;
            return this;
        }

        public Builder referrer(List<String> referrer) {
            this.referrer = referrer;
            return this;
        }

        public Builder requestUrl(List<String> requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        public Builder responseCode(List<Integer> responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public Builder threatFeedKey(List<String> threatFeedKey) {
            this.threatFeedKey = threatFeedKey;
            return this;
        }

        public Builder userAgent(List<String> userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder protectionRuleKey(List<String> protectionRuleKey) {
            this.protectionRuleKey = protectionRuleKey;
            return this;
        }

        public ListWafLogsRequest buildWithoutInvocationCallback() {
            return new ListWafLogsRequest(this.waasPolicyId, this.opcRequestId, this.limit, this.page, this.timeObservedGreaterThanOrEqualTo, this.timeObservedLessThan, this.textContains, this.accessRuleKey, this.action, this.clientAddress, this.countryCode, this.countryName, this.fingerprint, this.httpMethod, this.incidentKey, this.logType, this.originAddress, this.referrer, this.requestUrl, this.responseCode, this.threatFeedKey, this.userAgent, this.protectionRuleKey);
        }

        public String toString() {
            return "ListWafLogsRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", timeObservedGreaterThanOrEqualTo=" + this.timeObservedGreaterThanOrEqualTo + ", timeObservedLessThan=" + this.timeObservedLessThan + ", textContains=" + this.textContains + ", accessRuleKey=" + this.accessRuleKey + ", action=" + this.action + ", clientAddress=" + this.clientAddress + ", countryCode=" + this.countryCode + ", countryName=" + this.countryName + ", fingerprint=" + this.fingerprint + ", httpMethod=" + this.httpMethod + ", incidentKey=" + this.incidentKey + ", logType=" + this.logType + ", originAddress=" + this.originAddress + ", referrer=" + this.referrer + ", requestUrl=" + this.requestUrl + ", responseCode=" + this.responseCode + ", threatFeedKey=" + this.threatFeedKey + ", userAgent=" + this.userAgent + ", protectionRuleKey=" + this.protectionRuleKey + ")";
        }
    }

    public static enum LogType {
        Access("ACCESS"),
        ProtectionRules("PROTECTION_RULES"),
        JsChallenge("JS_CHALLENGE"),
        Captcha("CAPTCHA"),
        AccessRules("ACCESS_RULES"),
        ThreatFeeds("THREAT_FEEDS"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        AddressRateLimiting("ADDRESS_RATE_LIMITING");

        private final String value;
        private static Map<String, LogType> map;

        private LogType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LogType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid LogType: " + key);
        }

        static {
            map = new HashMap<String, LogType>();
            for (LogType v : LogType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum HttpMethod {
        Options("OPTIONS"),
        Get("GET"),
        Head("HEAD"),
        Post("POST"),
        Put("PUT"),
        Delete("DELETE"),
        Trace("TRACE"),
        Connect("CONNECT");

        private final String value;
        private static Map<String, HttpMethod> map;

        private HttpMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HttpMethod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid HttpMethod: " + key);
        }

        static {
            map = new HashMap<String, HttpMethod>();
            for (HttpMethod v : HttpMethod.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action {
        Block("BLOCK"),
        Detect("DETECT"),
        Bypass("BYPASS"),
        Log("LOG"),
        Redirected("REDIRECTED");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

