/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.waas.model.AccessRule;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class UpdateAccessRulesRequest
extends BmcRequest {
    private String waasPolicyId;
    private List<AccessRule> accessRules;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"waasPolicyId", "accessRules", "opcRequestId", "opcRetryToken", "ifMatch"})
    UpdateAccessRulesRequest(String waasPolicyId, List<AccessRule> accessRules, String opcRequestId, String opcRetryToken, String ifMatch) {
        this.waasPolicyId = waasPolicyId;
        this.accessRules = accessRules;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<AccessRule> getAccessRules() {
        return this.accessRules;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String waasPolicyId;
        private List<AccessRule> accessRules;
        private String opcRequestId;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAccessRulesRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.accessRules(o.getAccessRules());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAccessRulesRequest build() {
            UpdateAccessRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder accessRules(List<AccessRule> accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateAccessRulesRequest buildWithoutInvocationCallback() {
            return new UpdateAccessRulesRequest(this.waasPolicyId, this.accessRules, this.opcRequestId, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateAccessRulesRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", accessRules=" + this.accessRules + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

