/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.waas.model.UpdateAddressListDetails;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateAddressListRequest
extends BmcRequest {
    private String addressListId;
    private String opcRequestId;
    private String ifMatch;
    private UpdateAddressListDetails updateAddressListDetails;

    @ConstructorProperties(value={"addressListId", "opcRequestId", "ifMatch", "updateAddressListDetails"})
    UpdateAddressListRequest(String addressListId, String opcRequestId, String ifMatch, UpdateAddressListDetails updateAddressListDetails) {
        this.addressListId = addressListId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
        this.updateAddressListDetails = updateAddressListDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAddressListId() {
        return this.addressListId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public UpdateAddressListDetails getUpdateAddressListDetails() {
        return this.updateAddressListDetails;
    }

    public static class Builder {
        private String addressListId;
        private String opcRequestId;
        private String ifMatch;
        private UpdateAddressListDetails updateAddressListDetails;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAddressListRequest o) {
            this.addressListId(o.getAddressListId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.updateAddressListDetails(o.getUpdateAddressListDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAddressListRequest build() {
            UpdateAddressListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder updateAddressListDetails(UpdateAddressListDetails updateAddressListDetails) {
            this.updateAddressListDetails = updateAddressListDetails;
            return this;
        }

        public UpdateAddressListRequest buildWithoutInvocationCallback() {
            return new UpdateAddressListRequest(this.addressListId, this.opcRequestId, this.ifMatch, this.updateAddressListDetails);
        }

        public String toString() {
            return "UpdateAddressListRequest.Builder(addressListId=" + this.addressListId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ", updateAddressListDetails=" + this.updateAddressListDetails + ")";
        }
    }
}

