/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.waas.model.ThreatFeedAction;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class UpdateThreatFeedsRequest
extends BmcRequest {
    private String waasPolicyId;
    private List<ThreatFeedAction> threatFeeds;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"waasPolicyId", "threatFeeds", "opcRequestId", "ifMatch"})
    UpdateThreatFeedsRequest(String waasPolicyId, List<ThreatFeedAction> threatFeeds, String opcRequestId, String ifMatch) {
        this.waasPolicyId = waasPolicyId;
        this.threatFeeds = threatFeeds;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<ThreatFeedAction> getThreatFeeds() {
        return this.threatFeeds;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String waasPolicyId;
        private List<ThreatFeedAction> threatFeeds;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateThreatFeedsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.threatFeeds(o.getThreatFeeds());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateThreatFeedsRequest build() {
            UpdateThreatFeedsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder threatFeeds(List<ThreatFeedAction> threatFeeds) {
            this.threatFeeds = threatFeeds;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateThreatFeedsRequest buildWithoutInvocationCallback() {
            return new UpdateThreatFeedsRequest(this.waasPolicyId, this.threatFeeds, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateThreatFeedsRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", threatFeeds=" + this.threatFeeds + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

