/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.Certificate;
import java.beans.ConstructorProperties;

public class CreateCertificateResponse {
    private String opcRequestId;
    private String etag;
    private Certificate certificate;

    @ConstructorProperties(value={"opcRequestId", "etag", "certificate"})
    CreateCertificateResponse(String opcRequestId, String etag, Certificate certificate) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.certificate = certificate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Certificate certificate;

        public Builder copy(CreateCertificateResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.certificate(o.getCertificate());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder certificate(Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public CreateCertificateResponse build() {
            return new CreateCertificateResponse(this.opcRequestId, this.etag, this.certificate);
        }

        public String toString() {
            return "CreateCertificateResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", certificate=" + this.certificate + ")";
        }
    }
}

