/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.CustomProtectionRule;
import java.beans.ConstructorProperties;

public class CreateCustomProtectionRuleResponse {
    private String opcRequestId;
    private String etag;
    private CustomProtectionRule customProtectionRule;

    @ConstructorProperties(value={"opcRequestId", "etag", "customProtectionRule"})
    CreateCustomProtectionRuleResponse(String opcRequestId, String etag, CustomProtectionRule customProtectionRule) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.customProtectionRule = customProtectionRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public CustomProtectionRule getCustomProtectionRule() {
        return this.customProtectionRule;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private CustomProtectionRule customProtectionRule;

        public Builder copy(CreateCustomProtectionRuleResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.customProtectionRule(o.getCustomProtectionRule());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder customProtectionRule(CustomProtectionRule customProtectionRule) {
            this.customProtectionRule = customProtectionRule;
            return this;
        }

        public CreateCustomProtectionRuleResponse build() {
            return new CreateCustomProtectionRuleResponse(this.opcRequestId, this.etag, this.customProtectionRule);
        }

        public String toString() {
            return "CreateCustomProtectionRuleResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", customProtectionRule=" + this.customProtectionRule + ")";
        }
    }
}

