/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import java.beans.ConstructorProperties;

public class CreateWaasPolicyResponse {
    private String opcRequestId;
    private String etag;
    private String opcWorkRequestId;

    @ConstructorProperties(value={"opcRequestId", "etag", "opcWorkRequestId"})
    CreateWaasPolicyResponse(String opcRequestId, String etag, String opcWorkRequestId) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private String opcWorkRequestId;

        public Builder copy(CreateWaasPolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public CreateWaasPolicyResponse build() {
            return new CreateWaasPolicyResponse(this.opcRequestId, this.etag, this.opcWorkRequestId);
        }

        public String toString() {
            return "CreateWaasPolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", opcWorkRequestId=" + this.opcWorkRequestId + ")";
        }
    }
}

