/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.Certificate;
import java.beans.ConstructorProperties;

public class GetCertificateResponse {
    private String etag;
    private String opcRequestId;
    private Certificate certificate;

    @ConstructorProperties(value={"etag", "opcRequestId", "certificate"})
    GetCertificateResponse(String etag, String opcRequestId, Certificate certificate) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.certificate = certificate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Certificate certificate;

        public Builder copy(GetCertificateResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.certificate(o.getCertificate());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder certificate(Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public GetCertificateResponse build() {
            return new GetCertificateResponse(this.etag, this.opcRequestId, this.certificate);
        }

        public String toString() {
            return "GetCertificateResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", certificate=" + this.certificate + ")";
        }
    }
}

