/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.CustomProtectionRule;
import java.beans.ConstructorProperties;

public class GetCustomProtectionRuleResponse {
    private String etag;
    private String opcRequestId;
    private CustomProtectionRule customProtectionRule;

    @ConstructorProperties(value={"etag", "opcRequestId", "customProtectionRule"})
    GetCustomProtectionRuleResponse(String etag, String opcRequestId, CustomProtectionRule customProtectionRule) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.customProtectionRule = customProtectionRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public CustomProtectionRule getCustomProtectionRule() {
        return this.customProtectionRule;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private CustomProtectionRule customProtectionRule;

        public Builder copy(GetCustomProtectionRuleResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.customProtectionRule(o.getCustomProtectionRule());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder customProtectionRule(CustomProtectionRule customProtectionRule) {
            this.customProtectionRule = customProtectionRule;
            return this;
        }

        public GetCustomProtectionRuleResponse build() {
            return new GetCustomProtectionRuleResponse(this.etag, this.opcRequestId, this.customProtectionRule);
        }

        public String toString() {
            return "GetCustomProtectionRuleResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", customProtectionRule=" + this.customProtectionRule + ")";
        }
    }
}

