/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.JsChallenge;
import java.beans.ConstructorProperties;

public class GetJsChallengeResponse {
    private String etag;
    private String opcRequestId;
    private JsChallenge jsChallenge;

    @ConstructorProperties(value={"etag", "opcRequestId", "jsChallenge"})
    GetJsChallengeResponse(String etag, String opcRequestId, JsChallenge jsChallenge) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.jsChallenge = jsChallenge;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public JsChallenge getJsChallenge() {
        return this.jsChallenge;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private JsChallenge jsChallenge;

        public Builder copy(GetJsChallengeResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.jsChallenge(o.getJsChallenge());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder jsChallenge(JsChallenge jsChallenge) {
            this.jsChallenge = jsChallenge;
            return this;
        }

        public GetJsChallengeResponse build() {
            return new GetJsChallengeResponse(this.etag, this.opcRequestId, this.jsChallenge);
        }

        public String toString() {
            return "GetJsChallengeResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", jsChallenge=" + this.jsChallenge + ")";
        }
    }
}

