/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.ProtectionSettings;
import java.beans.ConstructorProperties;

public class GetProtectionSettingsResponse {
    private String etag;
    private String opcRequestId;
    private ProtectionSettings protectionSettings;

    @ConstructorProperties(value={"etag", "opcRequestId", "protectionSettings"})
    GetProtectionSettingsResponse(String etag, String opcRequestId, ProtectionSettings protectionSettings) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.protectionSettings = protectionSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ProtectionSettings getProtectionSettings() {
        return this.protectionSettings;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private ProtectionSettings protectionSettings;

        public Builder copy(GetProtectionSettingsResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.protectionSettings(o.getProtectionSettings());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder protectionSettings(ProtectionSettings protectionSettings) {
            this.protectionSettings = protectionSettings;
            return this;
        }

        public GetProtectionSettingsResponse build() {
            return new GetProtectionSettingsResponse(this.etag, this.opcRequestId, this.protectionSettings);
        }

        public String toString() {
            return "GetProtectionSettingsResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", protectionSettings=" + this.protectionSettings + ")";
        }
    }
}

