/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.WafConfig;
import java.beans.ConstructorProperties;

public class GetWafConfigResponse {
    private String etag;
    private String opcRequestId;
    private WafConfig wafConfig;

    @ConstructorProperties(value={"etag", "opcRequestId", "wafConfig"})
    GetWafConfigResponse(String etag, String opcRequestId, WafConfig wafConfig) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.wafConfig = wafConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public WafConfig getWafConfig() {
        return this.wafConfig;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private WafConfig wafConfig;

        public Builder copy(GetWafConfigResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.wafConfig(o.getWafConfig());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder wafConfig(WafConfig wafConfig) {
            this.wafConfig = wafConfig;
            return this;
        }

        public GetWafConfigResponse build() {
            return new GetWafConfigResponse(this.etag, this.opcRequestId, this.wafConfig);
        }

        public String toString() {
            return "GetWafConfigResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", wafConfig=" + this.wafConfig + ")";
        }
    }
}

